//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXXAPlayer.h
 * @brief		XAudio source t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AXXAPlayer_H_
#define INCG_IRIS_AXXAPlayer_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "xaudio_inchead.h"

#if	defined(_IRIS_SUPPORT_XAUDIO2)

namespace iris {
namespace ax {
namespace xaudio
{

//======================================================================
// declare
class CXAudio;

//======================================================================
// class
/**
 * @ingroup	XAudio
 * @brief	XAudio buffer NX
*/
class CXAPlayer : public IIrisObject
{
protected:
	LPXAUDIO2SOURCEVOICE	m_pSource;	//!< \[X
public:
	// RXgN^
	CXAPlayer(void);
	// fXgN^
	~CXAPlayer(void);

public:
	// 
	bool	Initialize(CXAudio* pXAudio, const WAVEFORMATEX* pFormat);

	// 
	void	Release(void);

public:
	// obt@Zbg
	bool	Submit(const LPXAUDIO2_BUFFER pBuffer, const LPXAUDIO2_BUFFER_WMA pBufferWMA=nullptr);

	// Đ
	bool	Play(void);
	// ~
	bool	Stop(void);

public:
	// Lǂ
	bool	IsValid(void)	const;
	// {[擾
	f32		GetVolume(void)	const;
	// {[ݒ
	bool	SetVolume(f32 volume, u32 OperationSett=XAUDIO2_COMMIT_NOW);

	// Ԃ̎擾
	void	GetState(LPXAUDIO2_VOICE_STATE pState)	const;
	// L[ɂobt@̎擾
	u32		GetBuffersQueued(void)	const;
};

}	// end of namespace xaudio
}	// end of namespace ax
}	// end of namespace iris

#endif

#endif
