//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_enum_class.h
 * @brief		cpp0x_enum_class t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_enum_class_H_
#define INCG_IRIS_cpp0x_enum_class_H_

//======================================================================
// include

//======================================================================
// define
#if	defined(__cplusplus0x)
#  define enum_class_begin(name_)		enum class name_
#  define enum_class_end(name_)
#else
#  define enum_class_begin(name_)		struct enum_##name_ { enum type
#  define enum_class_end(name_)			}; typedef ::cpp0x::enum_class<enum_##name_> name_
#endif

namespace cpp0x
{

//======================================================================
// class
template<typename TN, typename TE=TN::type>
class enum_class : public TN
{
	typedef TN	value_tye;
	typedef TE	enum_type;
	typedef enum_class<TN, TE>	_Myt;

	enum_type	m_value;

public:
	/**
	 * @name RXgN^
	 * @{
	*/
	enum_class(enum_type e=enum_type())	: m_value(e) {}
	/**
	 * @}
	*/

public:
	/**
	 * @name operator
	 * @{
	*/

	bool	operator == (enum_type e)	const	{ return m_value == e; }
	bool	operator != (enum_type e)	const	{ return m_value != e; }

	bool	operator == (const _Myt& e)	const	{ return m_value == e.m_value; }
	bool	operator != (const _Myt& e)	const	{ return m_value != e.m_value; }

	operator enum_type (void)	const			{ return m_value; }
	/**
	 * @}
	*/
};

}	// end of namespace iris

#endif
