//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_nullptr.h
 * @brief		c++0x nullptr t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_nullptr_H_
#define INCG_IRIS_cpp0x_nullptr_H_

//======================================================================
// include
#ifdef _IRIS_HAS_NULLPTR_T
#  undef _IRIS_HAS_NULLPTR_T
#endif

//======================================================================
// class
#if defined(__cplusplus0x) || defined(_IRIS_COMPILER_SUPORT_NULLPTR)
#  define	func_nullptr	nullptr
#elif	defined(__cplusplus_cli)
// C++/CLI
#  define	nullptr			0
#  define	func_nullptr	0

#elif defined(__cplusplus)
// C++
#if		defined(_MSC_VER) && (_MSC_VER < 1400)
#  define	nullptr			0
#  define	func_nullptr	0

#elif	defined(_MSC_VER) && (_MSC_VER >= 1600)
#  define	func_nullptr	nullptr

#else

#if		(defined(_IRIS_DEBUG) && !defined(_IRIS_NOT_SUPPORT_NULLPTR))

#ifndef _IRIS_HAS_NULLPTR_T
#define _IRIS_HAS_NULLPTR_T	//!< nullptr_t ^̒`邱Ƃ
#if	defined(__MWERKS__)
static
#else
const
#endif
/**
 * @brief	NULL|C^^
 * @details	(@ref section_autoexp_nullptr "autoexp")
*/
class nullptr_t
{
	void operator & (void)	const ;						//!< AhXQƂ֎~
public:
	template<class TC>
	operator TC* (void) const			{ return 0; }	//!< 񃁃o^̃k|C^ɕϊ
	template<class TC, class TCM>
	operator TCM TC::* (void) const 	{ return 0; }	//!< Cӂ̃o^̃k|C^ɕϊ
	nullptr_t(void) {}
} nullptr;	//!< NULL|C^^

#endif

// ꕔ̃RpCŊ֐|C^Ƃ̔rFłȂ
#ifndef func_nullptr
#  if		defined(__MWERKS__)
#    define	func_nullptr	0
#  else
#    define	func_nullptr	nullptr
#  endif
#endif

#else
#  ifndef nullptr
#    define	nullptr			0		// ReleaseRpC0ɂĂ
#  endif
#  ifndef func_nullptr
#    define	func_nullptr	0		// ReleaseRpC0ɂĂ
#  endif
#endif

#endif

#else
// C
#  ifndef nullptr
#    define	nullptr			((void *)0)
#  endif
#  ifndef func_nullptr
#    define	func_nullptr	((void *)0)
#  endif
#endif

#endif

/**
 * @addtogroup	autoexp
 * @{
 * @addtogroup	Visualizer
 * @section		section_autoexp_nullptr		; nullptr_t
 * @code
;------------------------------------------------------------------------------
; nullptr_t
;------------------------------------------------------------------------------
nullptr_t {
	preview
	(
		0
	)
}
 * @endcode
 * @}
*/
