//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_type_traits.hpp
 * @brief		type_traits t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_type_traits_HPP_
#define INCG_IRIS_cpp0x_type_traits_HPP_

//======================================================================
// include
#include "type_traits/cpp0x_abstract_traits.hpp"
#include "type_traits/cpp0x_align_traits.hpp"
#include "type_traits/cpp0x_arithmetic_traits.hpp"
#include "type_traits/cpp0x_array_traits.hpp"
#include "type_traits/cpp0x_base_derived_traits.hpp"
#include "type_traits/cpp0x_compound_traits.hpp"
#include "type_traits/cpp0x_convertible_traits.hpp"
#include "type_traits/cpp0x_class_traits.hpp"
#include "type_traits/cpp0x_empty_traits.hpp"
#include "type_traits/cpp0x_enum_traits.hpp"
#include "type_traits/cpp0x_extent_traits.hpp"
#include "type_traits/cpp0x_function_traits.hpp"
#include "type_traits/cpp0x_fundamental_traits.hpp"
#include "type_traits/cpp0x_iterator_traits.hpp"
#include "type_traits/cpp0x_nothrow_traits.hpp"
#include "type_traits/cpp0x_object_traits.hpp"
#include "type_traits/cpp0x_pod_traits.hpp"
#include "type_traits/cpp0x_polymorphic_traits.hpp"
#include "type_traits/cpp0x_reference_traits.hpp"
#include "type_traits/cpp0x_rank_traits.hpp"
#include "type_traits/cpp0x_same_traits.hpp"
#include "type_traits/cpp0x_scalar_traits.hpp"
#include "type_traits/cpp0x_trivial_traits.hpp"
#include "type_traits/cpp0x_union_traits.hpp"
#include "type_traits/cpp0x_virtual_traits.hpp"
#include "type_traits/cpp0x_xf_traits.hpp"
#include "type_traits/cpp0x_value_traits.hpp"

//======================================================================
// declare

namespace cpp0x
{

/**
 * @brief	̌^肷wp[
*/
template<typename TN>
class arg_type
{
	typedef typename remove_cv<TN>::type				nocv_type;
	typedef typename add_const<nocv_type>::type			const_type;
	typedef typename add_reference<const_type>::type	cf_type;
public:
	typedef typename iml::type_select< is_pod<TN>::value, nocv_type, cf_type >::type type;
};

}

#endif
