//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_abstract_traits.hpp
 * @brief		ۃNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_abstract_traits_HPP_
#define INCG_IRIS_cpp0x_abstract_traits_HPP_

//======================================================================
// include
#include "cpp0x_class_traits.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<class TC_>class is_abstract;			// ۃNXǂ

//======================================================================
// class
/// is abstract
template<class TC_>
class is_abstract
{
	template<class TT_>struct abstract_trait_impl
	{
		template<class TU_>
		static iml::detail::no_t	check_sig(TU_ (*)[1]);
		template<class TU_>
		static iml::detail::yes_t	check_sig(...);
#ifdef __GNUC__
		enum { value = is_iml_yes_t(abstract_trait_impl<TT_>::template check_sig<TT_>(0)) };
#else
		enum { value = is_iml_yes_t(check_sig<TT_>(0)) };
#endif
	};

	template<bool b, typename TMP>struct abstract_selector
	{
		template<class TU_>struct rebind { typedef iml::detail::false_type type; };
	};
	template<typename TMP>struct abstract_selector<true, TMP>
	{
		template<class TU_>struct rebind { typedef abstract_trait_impl<TU_> type; };
	};

	template<class TT_>struct abstract_trait
	{
		typedef abstract_selector< is_class<TT_>::value, void >	selector;
		typedef typename selector::template rebind<TT_>			binder;
		typedef typename binder::type							type;
		enum { value = type::value };
	};

public:
	enum { value = abstract_trait<TC_>::value };
};

}	// end of namespace cpp0x

#endif
