//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_arithmetic_traits.hpp
 * @brief		Z^ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_arithmetic_traits_HPP_
#define INCG_IRIS_cpp0x_arithmetic_traits_HPP_

//======================================================================
// include
#include "cpp0x_decimal_traits.hpp"
#include "cpp0x_integer_traits.hpp"
#include "../../ml/op/iml_op_or.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_>class is_arithmetic;		// Z^ǂ

//======================================================================
// class
/// is arithmetic
template<typename TN_>
class is_arithmetic
{
public:
	enum
	{
		value = iml::op_or< is_integral<TN_>::value
				, is_floating_point<TN_>::value >::value
	};
};

}	// end of namespace cpp0x

#endif
