//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_const_traits.hpp
 * @brief		type_traits t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_const_traits_HPP_
#define INCG_IRIS_cpp0x_const_traits_HPP_

//======================================================================
// include
#include "cpp0x_type_traits_def.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_>class is_const;		// constǂ
template<typename TN_>class add_const;		// TN_  constǉ
template<typename TN_>class remove_const;	// TN_const폜

//======================================================================
// class
/// is const
template<typename TN_>
class is_const
{
	template<typename _TT> struct const_trait 				: public iml::detail::false_type	{};
	template<typename _TT> struct const_trait<_TT const>	: public iml::detail::true_type		{};
public:
	enum { value = const_trait<TN_>::value };
};

/// add const trait
IRIS_SET_TYPE_TRAITS_DEC(add_const, const);
/// remove const trait
IRIS_REMOVE_TYPE_TRAITS_DEC(remove_const, const);

}	// end of namespace cpp0x

//======================================================================
// include
#include "cpp0x_type_traits_undef.hpp"

#endif
