//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_enum_traits.hpp
 * @brief		enum t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_enum_traits_HPP_
#define INCG_IRIS_cpp0x_enum_traits_HPP_

//======================================================================
// include
#include "cpp0x_arithmetic_traits.hpp"
#include "cpp0x_array_traits.hpp"
#include "cpp0x_class_traits.hpp"
#include "cpp0x_function_traits.hpp"
#include "cpp0x_union_traits.hpp"
#include "cpp0x_convertible_traits.hpp"
#include "cpp0x_reference_traits.hpp"
#include "../../ml/op/iml_op_or.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_>class is_enum;		// enumǂ

//======================================================================
// class
namespace detail
{

template<typename TN_>class is_class_or_union
{
public:
	enum { value = iml::op_or< is_class<TN_>::value
		, is_union<TN_>::value >::value };
};

}

/// is enum
template<typename TN_>
class is_enum
{
	struct int_convertible { int_convertible(int); };

	template<typename TMP, bool is_typename_airthmetic_or_reference = true>
	struct is_enum_helper
	{
		template<typename _TT>struct type : public iml::detail::false_type {};
	};
	template<typename TMP>
	struct is_enum_helper<TMP, false>
	{
		template<typename _TT>struct type
			: public is_convertible< typename add_reference<_TT>::type, int_convertible > {};
	};

	template<typename _TT>struct is_enum_impl
	{
#if	defined(__GNUC__)
		enum { selector = iml::op_or<
			  is_arithmetic<_TT>::value
			, is_reference<_TT>::value
			, is_function<_TT>::value
			, is_array<_TT>::value
			, detail::is_class_or_union<_TT>::value
		>::value };
#else
		enum { selector = iml::op_or<
			  is_arithmetic<_TT>::value
			, is_reference<_TT>::value
			, is_array<_TT>::value
			, detail::is_class_or_union<_TT>::value
		>::value };
#endif
		typedef is_enum_helper<void, selector>	helper;
		typedef typename helper::template type<_TT> type;
		enum { value = type::value };
	};

public:
	enum { value = is_enum_impl<TN_>::value };
};

}	// end of namespace cpp0x

#endif
