//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_function_traits.hpp
 * @brief		֐ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_function_traits_HPP_
#define INCG_IRIS_cpp0x_function_traits_HPP_

//======================================================================
// include
#include "cpp0x_pointer_traits.hpp"
#include "../../ml/iml_type_select.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_>class is_function;			// ֐ǂ
template<typename Function>class function_traits;	// ֐

//======================================================================
// class
/// is function
template<typename TN_>
class is_function
{
	template<typename TT_> struct function_trait : public iml::detail::false_type {};
	template<typename TT_> struct function_trait< TT_ (*) (void) > : public iml::detail::true_type {};
	template<typename TT_> struct function_trait< TT_ (*) (...) > : public iml::detail::true_type {};
	template<typename TT_, class TC_> struct function_trait< TT_ (TC_::*) (void) > : public iml::detail::true_type {};
	template<typename TT_, class TC_> struct function_trait< TT_ (TC_::*) (...) > : public iml::detail::true_type {};

	template<typename TT_, typename A1>
	struct function_trait< TT_ (*) (A1) > : public iml::detail::true_type {};
	template<typename TT_, typename A1>
	struct function_trait< TT_ (*) (A1, ...) > : public iml::detail::true_type {};

	template<typename TT_, typename A1, typename A2>
	struct function_trait< TT_ (*) (A1, A2) > : public iml::detail::true_type {};
	template<typename TT_, typename A1, typename A2>
	struct function_trait< TT_ (*) (A1, A2, ...) > : public iml::detail::true_type {};

	template<typename TT_, typename A1, typename A2, typename A3>
	struct function_trait< TT_ (*) (A1, A2, A3) > : public iml::detail::true_type {};
	template<typename TT_, typename A1, typename A2, typename A3>
	struct function_trait< TT_ (*) (A1, A2, A3, ...) > : public iml::detail::true_type {};

	template<typename TT_, typename A1, typename A2, typename A3, typename A4>
	struct function_trait< TT_ (*) (A1, A2, A3, A4) > : public iml::detail::true_type {};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, ...) > : public iml::detail::true_type {};

	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, A5) > : public iml::detail::true_type {};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, A5, ...) > : public iml::detail::true_type {};

	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, A5, A6) > : public iml::detail::true_type {};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, A5, A6, ...) > : public iml::detail::true_type {};

	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, A5, A6, A7) > : public iml::detail::true_type {};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, ...) > : public iml::detail::true_type {};

	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, A8) > : public iml::detail::true_type {};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, A8, ...) > : public iml::detail::true_type {};

	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, A8, A9) > : public iml::detail::true_type {};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, A8, A9, ...) > : public iml::detail::true_type {};

	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9
		, typename A10>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, A8, A9
		, A10) > : public iml::detail::true_type {};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9
		, typename A10>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, A8, A9
		, A10, ...) > : public iml::detail::true_type {};

	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9
		, typename A10, typename A11>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, A8, A9
		, A10, A11) > : public iml::detail::true_type {};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9
		, typename A10, typename A11>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, A8, A9
		, A10, A11, ...) > : public iml::detail::true_type {};

	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9
		, typename A10, typename A11, typename A12>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, A8, A9
		, A10, A11, A12) > : public iml::detail::true_type {};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9
		, typename A10, typename A11, typename A12>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, A8, A9
		, A10, A11, A12, ...) > : public iml::detail::true_type {};

	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9
		, typename A10, typename A11, typename A12, typename A13>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, A8, A9
		, A10, A11, A12, A13) > : public iml::detail::true_type {};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9
		, typename A10, typename A11, typename A12, typename A13>
	struct function_trait< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, A8, A9
		, A10, A11, A12, A13, ...) > : public iml::detail::true_type {};

public:
	enum { value = function_trait< typename cpp0x::add_pointer_once<TN_>::type >::value };
};

// detail
namespace detail
{
	template<typename Function> struct function_traits_helper;
	template<typename TT_>
	struct function_traits_helper< TT_ (*) (void) >
	{
		enum { arity = 0 };
		typedef TT_	result_type;
	};
	template<typename TT_, typename A1>
	struct function_traits_helper< TT_ (*) (A1) >
	{
		enum { arity = 1 };
		typedef TT_	result_type;
		typedef A1	arg1_type;
	};
	template<typename TT_, typename A1, typename A2>
	struct function_traits_helper< TT_ (*) (A1, A2) >
	{
		enum { arity = 2 };
		typedef TT_	result_type;
		typedef A1	arg1_type;
		typedef A2	arg2_type;
	};
	template<typename TT_, typename A1, typename A2, typename A3>
	struct function_traits_helper< TT_ (*) (A1, A2, A3) >
	{
		enum { arity = 3 };
		typedef TT_	result_type;
		typedef A1	arg1_type;
		typedef A2	arg2_type;
		typedef A3	arg3_type;
	};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4>
	struct function_traits_helper< TT_ (*) (A1, A2, A3, A4) >
	{
		enum { arity = 4 };
		typedef TT_	result_type;
		typedef A1	arg1_type;
		typedef A2	arg2_type;
		typedef A3	arg3_type;
		typedef A4	arg4_type;
	};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5>
	struct function_traits_helper< TT_ (*) (A1, A2, A3, A4, A5) >
	{
		enum { arity = 5 };
		typedef TT_	result_type;
		typedef A1	arg1_type;
		typedef A2	arg2_type;
		typedef A3	arg3_type;
		typedef A4	arg4_type;
		typedef A5	arg5_type;
	};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6>
	struct function_traits_helper< TT_ (*) (A1, A2, A3, A4, A5, A6) >
	{
		enum { arity = 6 };
		typedef TT_	result_type;
		typedef A1	arg1_type;
		typedef A2	arg2_type;
		typedef A3	arg3_type;
		typedef A4	arg4_type;
		typedef A5	arg5_type;
		typedef A6	arg6_type;
	};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7>
	struct function_traits_helper< TT_ (*) (A1, A2, A3, A4, A5, A6, A7) >
	{
		enum { arity = 7 };
		typedef TT_	result_type;
		typedef A1	arg1_type;
		typedef A2	arg2_type;
		typedef A3	arg3_type;
		typedef A4	arg4_type;
		typedef A5	arg5_type;
		typedef A6	arg6_type;
		typedef A7	arg7_type;
	};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8>
	struct function_traits_helper< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, A8) >
	{
		enum { arity = 8 };
		typedef TT_	result_type;
		typedef A1	arg1_type;
		typedef A2	arg2_type;
		typedef A3	arg3_type;
		typedef A4	arg4_type;
		typedef A5	arg5_type;
		typedef A6	arg6_type;
		typedef A7	arg7_type;
		typedef A8	arg8_type;
	};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9>
	struct function_traits_helper< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, A8, A9) >
	{
		enum { arity = 9 };
		typedef TT_	result_type;
		typedef A1	arg1_type;
		typedef A2	arg2_type;
		typedef A3	arg3_type;
		typedef A4	arg4_type;
		typedef A5	arg5_type;
		typedef A6	arg6_type;
		typedef A7	arg7_type;
		typedef A8	arg8_type;
		typedef A9	arg9_type;
	};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9
		, typename A10>
	struct function_traits_helper< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, A8, A9
		, A10) >
	{
		enum { arity = 10 };
		typedef TT_	result_type;
		typedef A1		arg1_type;
		typedef A2		arg2_type;
		typedef A3		arg3_type;
		typedef A4		arg4_type;
		typedef A5		arg5_type;
		typedef A6		arg6_type;
		typedef A7		arg7_type;
		typedef A8		arg8_type;
		typedef A9		arg9_type;
		typedef A10		arg10_type;
	};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9
		, typename A10, typename A11>
	struct function_traits_helper< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, A8, A9
		, A10, A11) >
	{
		enum { arity = 11 };
		typedef TT_	result_type;
		typedef A1		arg1_type;
		typedef A2		arg2_type;
		typedef A3		arg3_type;
		typedef A4		arg4_type;
		typedef A5		arg5_type;
		typedef A6		arg6_type;
		typedef A7		arg7_type;
		typedef A8		arg8_type;
		typedef A9		arg9_type;
		typedef A10		arg10_type;
		typedef A11		arg11_type;
	};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9
		, typename A10, typename A11, typename A12>
	struct function_traits_helper< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, A8, A9
		, A10, A11, A12) >
	{
		enum { arity = 12 };
		typedef TT_	result_type;
		typedef A1		arg1_type;
		typedef A2		arg2_type;
		typedef A3		arg3_type;
		typedef A4		arg4_type;
		typedef A5		arg5_type;
		typedef A6		arg6_type;
		typedef A7		arg7_type;
		typedef A8		arg8_type;
		typedef A9		arg9_type;
		typedef A10		arg10_type;
		typedef A11		arg11_type;
		typedef A12		arg12_type;
	};
	template<typename TT_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9
		, typename A10, typename A11, typename A12, typename A13>
	struct function_traits_helper< TT_ (*) (A1, A2, A3, A4, A5, A6, A7, A8, A9
		, A10, A11, A12, A13) >
	{
		enum { arity = 13 };
		typedef TT_		result_type;
		typedef A1		arg1_type;
		typedef A2		arg2_type;
		typedef A3		arg3_type;
		typedef A4		arg4_type;
		typedef A5		arg5_type;
		typedef A6		arg6_type;
		typedef A7		arg7_type;
		typedef A8		arg8_type;
		typedef A9		arg9_type;
		typedef A10		arg10_type;
		typedef A11		arg11_type;
		typedef A12		arg12_type;
		typedef A13		arg13_type;
	};

	// member
	template<typename TT_, typename TC_>
	struct function_traits_helper< TT_ (TC_::*) (void) >
	{
		enum { arity = 0 };
		typedef TT_	result_type;
	};
	template<typename TT_, typename TC_, typename A1>
	struct function_traits_helper< TT_ (TC_::*) (A1) >
	{
		enum { arity = 1 };
		typedef TT_	result_type;
		typedef A1	arg1_type;
	};
	template<typename TT_, typename TC_, typename A1, typename A2>
	struct function_traits_helper< TT_ (TC_::*) (A1, A2) >
	{
		enum { arity = 2 };
		typedef TT_	result_type;
		typedef A1	arg1_type;
		typedef A2	arg2_type;
	};
	template<typename TT_, typename TC_, typename A1, typename A2, typename A3>
	struct function_traits_helper< TT_ (TC_::*) (A1, A2, A3) >
	{
		enum { arity = 3 };
		typedef TT_	result_type;
		typedef A1	arg1_type;
		typedef A2	arg2_type;
		typedef A3	arg3_type;
	};
	template<typename TT_, typename TC_, typename A1, typename A2, typename A3, typename A4>
	struct function_traits_helper< TT_ (TC_::*) (A1, A2, A3, A4) >
	{
		enum { arity = 4 };
		typedef TT_	result_type;
		typedef A1	arg1_type;
		typedef A2	arg2_type;
		typedef A3	arg3_type;
		typedef A4	arg4_type;
	};
	template<typename TT_, typename TC_, typename A1, typename A2, typename A3, typename A4
		, typename A5>
	struct function_traits_helper< TT_ (TC_::*) (A1, A2, A3, A4, A5) >
	{
		enum { arity = 5 };
		typedef TT_	result_type;
		typedef A1	arg1_type;
		typedef A2	arg2_type;
		typedef A3	arg3_type;
		typedef A4	arg4_type;
		typedef A5	arg5_type;
	};
	template<typename TT_, typename TC_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6>
	struct function_traits_helper< TT_ (TC_::*) (A1, A2, A3, A4, A5, A6) >
	{
		enum { arity = 6 };
		typedef TT_	result_type;
		typedef A1	arg1_type;
		typedef A2	arg2_type;
		typedef A3	arg3_type;
		typedef A4	arg4_type;
		typedef A5	arg5_type;
		typedef A6	arg6_type;
	};
	template<typename TT_, typename TC_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7>
	struct function_traits_helper< TT_ (TC_::*) (A1, A2, A3, A4, A5, A6, A7) >
	{
		enum { arity = 7 };
		typedef TT_	result_type;
		typedef A1	arg1_type;
		typedef A2	arg2_type;
		typedef A3	arg3_type;
		typedef A4	arg4_type;
		typedef A5	arg5_type;
		typedef A6	arg6_type;
		typedef A7	arg7_type;
	};
	template<typename TT_, typename TC_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8>
	struct function_traits_helper< TT_ (TC_::*) (A1, A2, A3, A4, A5, A6, A7, A8) >
	{
		enum { arity = 8 };
		typedef TT_	result_type;
		typedef A1	arg1_type;
		typedef A2	arg2_type;
		typedef A3	arg3_type;
		typedef A4	arg4_type;
		typedef A5	arg5_type;
		typedef A6	arg6_type;
		typedef A7	arg7_type;
		typedef A8	arg8_type;
	};
	template<typename TT_, typename TC_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9>
	struct function_traits_helper< TT_ (TC_::*) (A1, A2, A3, A4, A5, A6, A7, A8, A9) >
	{
		enum { arity = 9 };
		typedef TT_	result_type;
		typedef A1	arg1_type;
		typedef A2	arg2_type;
		typedef A3	arg3_type;
		typedef A4	arg4_type;
		typedef A5	arg5_type;
		typedef A6	arg6_type;
		typedef A7	arg7_type;
		typedef A8	arg8_type;
		typedef A9	arg9_type;
	};
	template<typename TT_, typename TC_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9
		, typename A10>
	struct function_traits_helper< TT_ (TC_::*) (A1, A2, A3, A4, A5, A6, A7, A8, A9
		, A10) >
	{
		enum { arity = 10 };
		typedef TT_	result_type;
		typedef A1		arg1_type;
		typedef A2		arg2_type;
		typedef A3		arg3_type;
		typedef A4		arg4_type;
		typedef A5		arg5_type;
		typedef A6		arg6_type;
		typedef A7		arg7_type;
		typedef A8		arg8_type;
		typedef A9		arg9_type;
		typedef A10		arg10_type;
	};
	template<typename TT_, typename TC_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9
		, typename A10, typename A11>
	struct function_traits_helper< TT_ (TC_::*) (A1, A2, A3, A4, A5, A6, A7, A8, A9
		, A10, A11) >
	{
		enum { arity = 11 };
		typedef TT_	result_type;
		typedef A1		arg1_type;
		typedef A2		arg2_type;
		typedef A3		arg3_type;
		typedef A4		arg4_type;
		typedef A5		arg5_type;
		typedef A6		arg6_type;
		typedef A7		arg7_type;
		typedef A8		arg8_type;
		typedef A9		arg9_type;
		typedef A10		arg10_type;
		typedef A11		arg11_type;
	};
	template<typename TT_, typename TC_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9
		, typename A10, typename A11, typename A12>
	struct function_traits_helper< TT_ (TC_::*) (A1, A2, A3, A4, A5, A6, A7, A8, A9
		, A10, A11, A12) >
	{
		enum { arity = 12 };
		typedef TT_	result_type;
		typedef A1		arg1_type;
		typedef A2		arg2_type;
		typedef A3		arg3_type;
		typedef A4		arg4_type;
		typedef A5		arg5_type;
		typedef A6		arg6_type;
		typedef A7		arg7_type;
		typedef A8		arg8_type;
		typedef A9		arg9_type;
		typedef A10		arg10_type;
		typedef A11		arg11_type;
		typedef A12		arg12_type;
	};
	template<typename TT_, typename TC_, typename A1, typename A2, typename A3, typename A4
		, typename A5, typename A6, typename A7, typename A8, typename A9
		, typename A10, typename A11, typename A12, typename A13>
	struct function_traits_helper< TT_ (TC_::*) (A1, A2, A3, A4, A5, A6, A7, A8, A9
		, A10, A11, A12, A13) >
	{
		enum { arity = 13 };
		typedef TT_		result_type;
		typedef A1		arg1_type;
		typedef A2		arg2_type;
		typedef A3		arg3_type;
		typedef A4		arg4_type;
		typedef A5		arg5_type;
		typedef A6		arg6_type;
		typedef A7		arg7_type;
		typedef A8		arg8_type;
		typedef A9		arg9_type;
		typedef A10		arg10_type;
		typedef A11		arg11_type;
		typedef A12		arg12_type;
		typedef A13		arg13_type;
	};

}	// end of namespace detail

/// function traits
template<typename Function>
class function_traits : public detail::function_traits_helper< typename add_pointer_once_without_scope<Function>::type >
{
};

}	// end of namespace cpp0x

#endif
