//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_integer_traits.hpp
 * @brief		 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_integer_traits_HPP_
#define INCG_IRIS_cpp0x_integer_traits_HPP_

//======================================================================
// include
#include "cpp0x_cv_traits.hpp"
#include "cpp0x_type_traits_def.hpp"
#include "../../ml/op/iml_op_or.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_>class is_char;			// charǂ
template<typename TN_>class is_s_char;			// signed charǂ
template<typename TN_>class is_u_char;			// unsigned charǂ
template<typename TN_>class is_char_traits;		// char ǂ

template<typename TN_>class is_wchar_t;			// wchar_tǂ

template<typename TN_>class is_short;			// shortǂ
template<typename TN_>class is_s_short;			// signed shortǂ
template<typename TN_>class is_u_short;			// unsigned shortǂ
template<typename TN_>class is_short_traits;	// short ǂ

template<typename TN_>class is_int;				// intǂ
template<typename TN_>class is_s_int;			// signed intǂ
template<typename TN_>class is_u_int;			// unsigned intǂ
template<typename TN_>class is_int_traits;		// int ǂ

template<typename TN_>class is_long;			// long ǂ
template<typename TN_>class is_s_long;			// signed long ǂ
template<typename TN_>class is_u_long;			// unsigned long ǂ
template<typename TN_>class is_long_traits;		// long ǂ

template<typename TN_>class is_long_long;		// long long ǂ
template<typename TN_>class is_s_long_long;		// signed long long ǂ
template<typename TN_>class is_u_long_long;		// unsigned long long ǂ
template<typename TN_>class is_long_long_traits;// long long ǂ

template<typename TN_>class is_signed;		// signed ǂ
template<typename TN_>class is_unsigned;	// unsigned ǂ

template<typename TN_>class is_integral;			// ǂ


//======================================================================
// class
/// is char
IRIS_IS_TYPE_TRAITS_DEC(is_char, char);
IRIS_IS_TYPE_TRAITS_DEC(is_s_char, signed char);
IRIS_IS_TYPE_TRAITS_DEC(is_u_char, unsigned char);

/// is char_trait
template<typename TN_>
class is_char_traits
{
	typedef typename remove_cv<TN_>::type	type;
public:
	enum { value = iml::op_or< is_char<type>::value
					, is_s_char<type>::value
					, is_u_char<type>::value >::value
	};
};

/// is wchar_t
IRIS_IS_TYPE_TRAITS_DEC(is_wchar_t, wchar_t);

/// is short
IRIS_IS_TYPE_TRAITS_DEC(is_short, short);
IRIS_IS_TYPE_TRAITS_DEC(is_s_short, signed short);
IRIS_IS_TYPE_TRAITS_DEC(is_u_short, unsigned short);

/// is short_trait
template<typename TN_>
class is_short_traits
{
	typedef typename remove_cv<TN_>::type	type;
public:
	enum { value = iml::op_or< is_short<type>::value
					, is_s_short<type>::value
					, is_u_short<type>::value >::value
	};
};

/// is int
IRIS_IS_TYPE_TRAITS_DEC(is_int, int);
IRIS_IS_TYPE_TRAITS_DEC(is_s_int, signed int);
IRIS_IS_TYPE_TRAITS_DEC(is_u_int, unsigned int);

/// is int_trait
template<typename TN_>
class is_int_traits
{
	typedef typename remove_cv<TN_>::type	type;
public:
	enum { value = iml::op_or< is_int<type>::value
					, is_s_int<type>::value
					, is_u_int<type>::value >::value
	};
};

/// is long
IRIS_IS_TYPE_TRAITS_DEC(is_long, long);
IRIS_IS_TYPE_TRAITS_DEC(is_s_long, signed long);
IRIS_IS_TYPE_TRAITS_DEC(is_u_long, unsigned long);

/// is long_trait
template<typename TN_>
class is_long_traits
{
	typedef typename remove_cv<TN_>::type	type;
public:
	enum { value = iml::op_or< is_long<type>::value
					, is_s_long<type>::value
					, is_u_long<type>::value >::value
	};
};

/// is long long
IRIS_IS_TYPE_TRAITS_DEC(is_long_long, long long);
IRIS_IS_TYPE_TRAITS_DEC(is_s_long_long, signed long long);
IRIS_IS_TYPE_TRAITS_DEC(is_u_long_long, unsigned long long);

/// is long_long_trait
template<typename TN_>
class is_long_long_traits
{
	typedef typename remove_cv<TN_>::type	type;
public:
	enum { value = iml::op_or< is_long_long<type>::value
					, is_s_long_long<type>::value
					, is_u_long_long<type>::value >::value
	};
};

/// is signed
template<typename TN_>
class is_signed
{
	typedef typename remove_cv<TN_>::type	type;
public:
	enum { value = iml::op_or< is_s_char<type>::value
				, is_s_short<type>::value
				, is_s_int<type>::value
				, is_s_long<type>::value
				, is_s_long_long<type>::value >::value
	};
};

/// is unsigned
template<typename TN_>
class is_unsigned
{
	typedef typename remove_cv<TN_>::type	type;
public:
	enum { value = iml::op_or< is_u_char<type>::value
				, is_u_short<type>::value
				, is_u_int<type>::value
				, is_u_long<type>::value
				, is_u_long_long<type>::value >::value
	};
};

/// is integral
template<typename TN_>
class is_integral
{
	typedef typename remove_cv<TN_>::type	type;
public:
	enum { value = iml::op_or< is_char_traits<type>::value
					, is_wchar_t<type>::value
					, is_short_traits<type>::value
					, is_int_traits<type>::value
					, is_long_traits<type>::value
					, is_long_long_traits<type>::value >::value
	};
};

}	// end of namespace cpp0x

//======================================================================
// include
#include "cpp0x_type_traits_undef.hpp"

#endif
