//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_object_traits.hpp
 * @brief		IuWFNg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_object_traits_HPP_
#define INCG_IRIS_cpp0x_object_traits_HPP_

//======================================================================
// include
#include "cpp0x_function_traits.hpp"
#include "cpp0x_void_traits.hpp"
#include "cpp0x_reference_traits.hpp"
#include "../../ml/iml_op.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_>class is_object;		// IuWFNgǂ

//======================================================================
// class
/// is object
template<typename TN_>
class is_object
{
	template<class _TT>struct is_object_impl
	{
		enum { value = iml::op_and<
			  iml::op_not< is_reference<_TT>::value >::value
			, iml::op_not< is_void<_TT>::value >::value
			, iml::op_not< is_function<_TT>::value >::value
		>::value };
	};
public:
	enum { value = is_object_impl<TN_>::value };
};

}	// end of namespace cpp0x

#endif
