//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_pointer_traits.hpp
 * @brief		type_traits t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_pointer_traits_HPP_
#define INCG_IRIS_cpp0x_pointer_traits_HPP_

//======================================================================
// include
#include "cpp0x_cv_traits.hpp"
#include "cpp0x_type_traits_def.hpp"
#include "../../ml/op/iml_op_or.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_>class is_pointer;							// |C^[ǂ
template<typename TN_>class is_member_pointer;					// o[|C^[ǂ
template<typename TN_>class is_pointer_without_scope;			// o[|C^[ or |C^ǂ
template<typename TN_>class is_member_function_pointer;	// o[֐|C^[ǂ
template<typename TN_>class is_member_object_pointer;	// o[IuWFNg|C^[ǂ
template<typename TN_>class add_pointer;		// TN_  |C^[ǉ
template<typename TN_>class add_pointer_once;	// TN_  |C^[ǉ
template<typename TN_>class remove_pointer;		// TN_|C^[폜

//======================================================================
// class
/// is pointer
template<typename TN_>
class is_pointer
{
	template<typename TT_> struct pointer_trait : public iml::detail::false_type	{};
	template<typename TT_> struct pointer_trait<TT_*> : public iml::detail::true_type {};
	typedef typename remove_cv<TN_>::type	type;
public:
	enum { value = pointer_trait<type>::value };
};

/// is member pointer
template<typename TN_>
class is_member_pointer
{
	template<typename TT_> struct pointer_trait : public iml::detail::false_type	{};
	template<typename TT_, class _TC> struct pointer_trait<TT_ _TC::*> : public iml::detail::true_type	{};
	typedef typename remove_cv<TN_>::type	type;
public:
	enum { value = pointer_trait<type>::value };
};

/// is pointer without scope
template<typename TN_>
class is_pointer_without_scope
{
	typedef typename remove_cv<TN_>::type	type;
public:
	enum { value = iml::op_or< is_pointer<type>::value
					, is_member_pointer<type>::value
					>::value
	};
};

/// is member function pointer
template<typename TN_>
class is_member_function_pointer
{
	template<typename TT_> struct pointer_trait : public iml::detail::false_type	{};
	template<typename TT_, class _TC>
	struct pointer_trait<TT_ (_TC::*)(void)> : public iml::detail::true_type	{};
	template<typename TT_, class _TC>
	struct pointer_trait<TT_ (_TC::*)(...)> : public iml::detail::true_type	{};

	template<typename TT_, class _TC, typename _A1>
	struct pointer_trait<TT_ (_TC::*)(_A1)> : public iml::detail::true_type	{};
	template<typename TT_, class _TC, typename _A1>
	struct pointer_trait<TT_ (_TC::*)(_A1, ...)> : public iml::detail::true_type	{};

	template<typename TT_, class _TC, typename _A1, typename _A2>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2)> : public iml::detail::true_type	{};
	template<typename TT_, class _TC, typename _A1, typename _A2>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, ...)> : public iml::detail::true_type	{};

	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3)> : public iml::detail::true_type	{};
	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, ...)> : public iml::detail::true_type	{};

	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, _A4)> : public iml::detail::true_type	{};
	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, _A4, ...)> : public iml::detail::true_type	{};

	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, _A4, _A5)> : public iml::detail::true_type	{};
	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, _A4, _A5, ...)> : public iml::detail::true_type	{};

	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6)> : public iml::detail::true_type	{};
	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, ...)> : public iml::detail::true_type	{};

	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7)> : public iml::detail::true_type	{};
	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, ...)> : public iml::detail::true_type	{};

	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8)> : public iml::detail::true_type	{};
	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8, ...)> : public iml::detail::true_type	{};

	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8
		, typename _A9>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8, _A9)> : public iml::detail::true_type	{};
	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8
		, typename _A9>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8, _A9, ...)> : public iml::detail::true_type	{};

	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8
		, typename _A9, typename _A10>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8, _A9, _A10)> : public iml::detail::true_type	{};
	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8
		, typename _A9, typename _A10>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8, _A9, _A10, ...)> : public iml::detail::true_type	{};

	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8
		, typename _A9, typename _A10, typename _A11>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8, _A9, _A10, _A11)> : public iml::detail::true_type	{};
	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8
		, typename _A9, typename _A10, typename _A11>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8, _A9, _A10, _A11, ...)> : public iml::detail::true_type	{};

	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8
		, typename _A9, typename _A10, typename _A11, typename _A12>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8, _A9, _A10, _A11, _A12)> : public iml::detail::true_type	{};
	template<typename TT_, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8
		, typename _A9, typename _A10, typename _A11, typename _A12>
	struct pointer_trait<TT_ (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8, _A9, _A10, _A11, _A12, ...)> : public iml::detail::true_type	{};

	typedef typename remove_cv<TN_>::type	type;
public:
	enum { value = pointer_trait<type>::value };
};

/// is member object pointer
template<typename TN_>
class is_member_object_pointer
{
public:
	enum { value = iml::op_and<
					  is_member_pointer<TN_>::value
					, iml::op_not< is_member_function_pointer<TN_>::value >::value
					>::value };
};

/// add pointer_trait
IRIS_ADD_TYPE_TRAITS_DEC(add_pointer, *);
/// add pointer_trait once
IRIS_SET_TYPE_TRAITS_DEC(add_pointer_once, *);
/// remove pointer_trait
IRIS_REMOVE_TYPE_TRAITS_DEC(remove_pointer, *);

template<typename TN_>
class add_pointer_once_without_scope
{
public:
	typedef typename iml::type_select< is_pointer_without_scope<TN_>::value, TN_, typename add_pointer_once<TN_>::type >::type type;
};


//======================================================================
// function
template<typename TN_>
bool	IsPointer(TN_)			{ return is_pointer<TN_>::value; }
template<typename TN_>
bool	IsMemberPointer(TN_)	{ return is_member_pointer<TN_>::value; }

}	// end of namespace cpp0x

//======================================================================
// include
#include "cpp0x_type_traits_undef.hpp"

#endif
