//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_rank_traits.hpp
 * @brief		z t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_rank_traits_HPP_
#define INCG_IRIS_cpp0x_rank_traits_HPP_

//======================================================================
// include
#include "cpp0x_cv_traits.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_>class rank;			// z̎

//======================================================================
// class
/// rank
template<typename TN_>
class rank
{
	template<typename TT_, size_t N>
	struct rank_trait { enum { value = N }; };

	template<typename TT_, size_t R, size_t N>
	struct rank_trait<TT_[R], N> { enum { value = rank_trait<TT_, N+1>::value }; };

#if	!defined(__MWERKS__)
	template<typename TT_, size_t N>
	struct rank_trait<TT_[], N> { enum { value = rank_trait<TT_, N+1>::value }; };
#endif

	typedef typename remove_cv<TN_>::type	type;
public:
	enum { value = rank_trait<type, 0>::value };
};

}	// end of namespace cpp0x

#endif
