//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_scalar_traits.hpp
 * @brief		XJ[^ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_scalar_traits_HPP_
#define INCG_IRIS_cpp0x_scalar_traits_HPP_

//======================================================================
// include
#include "cpp0x_arithmetic_traits.hpp"
#include "cpp0x_enum_traits.hpp"
#include "cpp0x_pointer_traits.hpp"
#include "../../ml/op/iml_op_or.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_>class is_scalar;			// XJ[^ǂ

//======================================================================
// class
/// is scalar
template<typename TN_>
class is_scalar
{
public:
	enum
	{
		value = iml::op_or<
				  is_arithmetic<TN_>::value
				, is_enum<TN_>::value
				, is_pointer<TN_>::value
				, is_member_pointer<TN_>::value
		>::value
	};
};

}	// end of namespace cpp0x

#endif
