//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_type_traits_def.hpp
 * @brief		type_traits t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_type_traits_def_HPP_
#define INCG_IRIS_cpp0x_type_traits_def_HPP_

//======================================================================
// include
#include "cpp0x_type_traits_detail.hpp"

//======================================================================
// define
// B̌^f
#if defined(_MSC_VER) && (_MSC_VER <= 1200)		// VC6.0ȑÓAꉻłȂ
#define IRIS_IS_TYPE_TRAITS_DEC(name, _type)				\
	template<typename TN_>									\
	class name												\
	{														\
		template<typename TT_> struct name##_trait			\
			: public iml::detail::false_type	{};			\
		template<> struct name##_trait<_type>				\
			: public iml::detail::true_type		{};			\
		typedef typename remove_cv<TN_>::type	type;		\
	public:													\
		enum { value = name##_trait<type>::value };			\
	}
#else
#define IRIS_IS_TYPE_TRAITS_DEC(name, type_)						\
	template<typename TN_>											\
	class name														\
	{																\
		template<typename TT_, typename TMP> struct name##_trait	\
			: public iml::detail::false_type	{};					\
		template<typename TMP> struct name##_trait<type_, TMP>		\
			: public iml::detail::true_type		{};					\
		typedef typename remove_cv<TN_>::type	type;				\
	public:															\
		enum { value = name##_trait<type, type>::value };			\
	}
#endif

// ̒ǉiłɓĂꍇ͉Ȃj
#define IRIS_SET_TYPE_TRAITS_DEC(name, trait)					\
	template<typename TN_>										\
	class name													\
	{															\
		template<typename TT_> struct name##_trait				\
		{														\
			typedef TT_	trait	type;							\
		};														\
		template<typename TT_> struct name##_trait<TT_ trait>	\
		{														\
			typedef TT_	trait	type;							\
		};														\
	public:														\
		typedef typename name##_trait<TN_>::type	type;		\
	}

// ̒ǉ
#define IRIS_ADD_TYPE_TRAITS_DEC(name, trait)					\
	template<typename TN_>										\
	class name													\
	{															\
		template<typename TT_> struct name##_trait				\
		{														\
			typedef TT_	trait	type;							\
		};														\
		template<typename TT_> struct name##_trait<TT_ &>		\
		{														\
			typedef TT_	trait	type;							\
		};														\
	public:														\
		typedef typename name##_trait<TN_>::type	type;		\
	}

// ̍폜
#define IRIS_REMOVE_TYPE_TRAITS_DEC(name, trait)				\
	template<typename TN_>										\
	class name													\
	{															\
		template<typename TT_> struct name##_trait				\
		{														\
			typedef TT_		type;								\
		};														\
		template<typename TT_> struct name##_trait<TT_ trait>	\
		{														\
			typedef TT_		type;								\
		};														\
	public:														\
		typedef typename name##_trait<TN_>::type	type;		\
	}

#endif
