//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndBaseEncoding.h
 * @brief		Base GR[fBONXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndBaseEncoding_H_
#define INCG_IRIS_FndBaseEncoding_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../ml/iml_math.hpp"

namespace iris {
namespace fnd
{

//======================================================================
// enum
typedef enum eBASE_ENCODING_TYPE
{
	eBASE16		= 0x00000004,
	eBASE32		= 0x00000005,
	eBASE32_HEX	= 0x00010005,
	eBASE64		= 0x00000006
} eBASE_ENCODING_TYPE;

//======================================================================
// declare
template<typename CHARTYPE_, eBASE_ENCODING_TYPE TYPE>class CTBaseEncoding;

//======================================================================
// typedef

//======================================================================
// class
template<eBASE_ENCODING_TYPE TYPE>class CBaseEncodingA : public CTBaseEncoding< CHAR, TYPE> {};
template<eBASE_ENCODING_TYPE TYPE>class CBaseEncodingW : public CTBaseEncoding<WCHAR, TYPE> {};
template<eBASE_ENCODING_TYPE TYPE>class CBaseEncoding  : public CTBaseEncoding<TCHAR, TYPE> {};

/**
 * @brief	Base GR[fBONX
*/
template<typename CHARTYPE_, eBASE_ENCODING_TYPE TYPE>
class CTBaseEncoding : public IIrisObject
{
	typedef CTBaseEncoding<CHARTYPE_, TYPE>	_Myt;

protected:
	static const int BITS	= TYPE & 0xFF;	//!< bit
	static const u8  MASK	= (1<<BITS)-1;
	static const int LCM	= iml::static_lcm<BITS, 8>::value;
	static const int NBASE	= LCM/BITS;		//!< base R[h ACg

protected:
	typedef	CHARTYPE_			_Mychar;
	typedef CHARTYPE_			*_Mylpstr;
	typedef const CHARTYPE_		*_Mylpcstr;

public:
	// RXgN^
	CTBaseEncoding(void);
public:
	// GR[h
	static u32	Encode(_Mylpstr dst, size_t length, const u8* src, size_t size);
	// fR[h
	static u32	Decode(iris::u8 *dst, size_t size, _Mylpcstr src, size_t length);

private:
	static _Mychar	ToBase(u8 c);
	static u8		ToPlane(_Mychar c);
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
