//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndEUC.cpp
 * @brief		EUC R[h t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndEUC_CPP_

//======================================================================
// include
#include "FndEUC.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**********************************************************************//**
 *
 * EUC }`oCg̑1oCgǂ
 *
 * @note	0xA1`0xFE	: 
 *
 ----------------------------------------------------------------------
 * @param [in]	code	= ʂ镶
 * @return	^Ul
*//***********************************************************************/
bool CEUC::IsLeadByte(BYTE code)
{
	const BYTE AREA = 0xFEu - 0xA1u;
	BYTE c = code - 0xA1u;
	return c <= AREA;
}

/**********************************************************************//**
 *
 * EUC pJ^Jȋ1oCgǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	code	= ʂ镶
 * @return	^Ul
*//***********************************************************************/
bool CEUC::IsLeadByteSS2(BYTE code)
{
	return code == 0x8Eu;
}

/**********************************************************************//**
 *
 * EUC ⏕̑1oCgǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	code	= ʂ镶
 * @return	^Ul
*//***********************************************************************/
bool CEUC::IsLeadByteSS3(BYTE code)
{
	return code == 0x8Fu;
}

/**********************************************************************//**
 *
 * EUC }`oCg2oCgڈȍ~ǂ
 *
 * @note	0xA1`0xFE
 *
 ----------------------------------------------------------------------
 * @param [in]	code	= ʂ镶
 * @return	^Ul
*//***********************************************************************/
bool CEUC::IsTrailByte(BYTE code)
{
	const BYTE AREA = 0xFEu - 0xA1u;
	BYTE c = code - 0xA1u;
	return c <= AREA;
}

/**********************************************************************//**
 *
 * EUC pJ^Ji2oCgڂǂ
 *
 * @note	0xA1`0xDF
 *
 ----------------------------------------------------------------------
 * @param [in]	code	= ʂ镶
 * @return	^Ul
*//***********************************************************************/
bool CEUC::IsTrailByteSS2(BYTE code)
{
	const BYTE AREA = 0xDFu - 0xA1u;
	BYTE c = code - 0xA1u;
	return c <= AREA;
}

/**********************************************************************//**
 *
 * EUC ̕\Ȃǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	code	= ʂ镶
 * @return	^Ul
*//***********************************************************************/
bool CEUC::IsMatch(BYTE code)
{
	if( code <= 0x7Fu ) return true;
	if( code == 0xFFu ) return false;
	if( code < 0x8Eu ) return false;
	return true;
}

/**********************************************************************//**
 *
 * EUC \ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= ʂobt@
 * @param [in]	size		= obt@TCY
 * @param [out]	weight		= d݁ĩGR[fBOƂ̈vx̔rɎg܂j
 * @return	^Ul
*//***********************************************************************/
bool CEUC::IsMatch(const void* lpBuffer, size_t size, int& weight)
{
	const BYTE*	buf = static_cast<const BYTE*>(lpBuffer);
	weight = 0;

	bool ret = true;
	for( size_t i=0; i < size-1; ++i, ++buf )
	{
		if( IsLeadByte(*buf) )
		{
			++i, ++buf;
			if( IsTrailByte(*buf) )
			{
				weight += 2;
			}
		}
		else if( IsLeadByteSS2(*buf) )
		{
			++i, ++buf;
			if( IsTrailByteSS2(*buf) )
			{
				weight += 2;
			}
		}
		else if( IsLeadByteSS3(*buf) )
		{
			if( i < size-2 )
			{
				++i, ++buf;
				if( IsTrailByte(*buf) )
				{
					++i, ++buf;
					if( CEUC::IsTrailByte(*buf) )
					{
						weight += 3;
					}
				}
			}
		}
		else
		{
			if( IsMatch(*buf) )
			{
				++weight;
			}
			else
			{
				ret = false;
			}
		}
	}
	if( IsMatch(*buf) )
	{
		++weight;
	}
	else
	{
		ret = false;
	}
	return ret;
}

/**********************************************************************//**
 *
 * EUC \ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= ʂobt@
 * @param [in]	size		= obt@TCY
 * @param [out]	weight		= d݁ĩGR[fBOƂ̈vx̔rɎg܂j
 * @param [out]	negative	= sv̏d݁ĩGR[fBOƂ̈vx̔rɎg܂j
 * @return	^Ul
*//***********************************************************************/
bool CEUC::IsMatch(const void* lpBuffer, size_t size, int& weight, int& negative)
{
	const BYTE*	buf = static_cast<const BYTE*>(lpBuffer);
	weight = 0;
	negative = 0;

	for( size_t i=0; i < size-1; ++i, ++buf )
	{
		if( IsLeadByte(*buf) )
		{
			++i, ++buf;
			if( IsTrailByte(*buf) )
			{
				weight += 2;
			}
			else
			{
				negative += 2;
			}
		}
		else if( IsLeadByteSS2(*buf) )
		{
			++i, ++buf;
			if( IsTrailByteSS2(*buf) )
			{
				weight += 2;
			}
			else
			{
				negative += 2;
			}
		}
		else if( IsLeadByteSS3(*buf) )
		{
			if( i < size-2 )
			{
				++i, ++buf;
				if( IsTrailByte(*buf) )
				{
					++i, ++buf;
					if( CEUC::IsTrailByte(*buf) )
					{
						weight += 3;
					}
					else
					{
						negative += 3;
					}
				}
			}
		}
		else
		{
			if( IsMatch(*buf) )
			{
				//++weight;
			}
			else
			{
				++negative;
			}
		}
	}
	if( IsMatch(*buf) )
	{
		//++weight;
	}
	else
	{
		++negative;
	}

	if( negative > 0 && (negative >= weight) ) return false;
	return true;
}

}	// end of namespace fnd
}	// end of namespace iris
