//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndEUC.h
 * @brief		EUC R[h t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndEUC_H_
#define INCG_IRIS_FndEUC_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	EUC R[hNX
*/
class CEUC : public IIrisObject
{
public:
	// EUC }`oCg̑1oCgǂ
	static bool	IsLeadByte(BYTE code);
	// EUC pJ^Jȋ1oCgǂ
	static bool	IsLeadByteSS2(BYTE code);
	// EUC ⏕̑1oCgǂ
	static bool	IsLeadByteSS3(BYTE code);
	// EUC }`oCg2oCgڈȍ~ǂ
	static bool	IsTrailByte(BYTE code);
	// EUC pJ^Ji2oCgڂǂ
	static bool	IsTrailByteSS2(BYTE code);
public:
	// EUC ̕\ǂ
	static bool	IsMatch(BYTE code);
	// EUC ǂ
	static bool	IsMatch(const void* lpBuffer, size_t size, int& weight);
	static bool	IsMatch(const void* lpBuffer, size_t size, int& weight, int& negative);
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
