//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSJIS.cpp
 * @brief		Shift JIS R[h t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndSJIS_CPP_

//======================================================================
// include
#include "FndSJIS.h"
#include "FndASCII.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**********************************************************************//**
 *
 * SJIS 2oCg̑1oCgǂ
 *
 * @note	Windows 31J	: 0x81`0x9FC0xE0`0xFC
 *			W        : 0x81`0x9FC0xE0`0xEF
 *
 ----------------------------------------------------------------------
 * @param [in]	code	= ʂ镶
 * @return	^Ul
*//***********************************************************************/
bool CSJIS::IsLeadByte(BYTE code)
{
	const BYTE LAREA = DAREA / 2;
	BYTE c = code ^ 0x20u;	// 0x81~0x9F || 0xE0~0xFC(EF) -> 0xA1~0xDC(CF) ɒu
	c -= 0xA1;				// ɁA0x00~ ̋ԂɃVtg܂
	return c < LAREA;
}

/**********************************************************************//**
 *
 * SJIS 2oCg̑2oCgǂ
 *
 * @note	0x40`0x7EC0x80`0xFC
 *
 ----------------------------------------------------------------------
 * @param [in]	code	= ʂ镶
 * @return	^Ul
*//***********************************************************************/
bool CSJIS::IsTrailByte(BYTE code)
{
	const BYTE TAREA = PAREA * 2;
	BYTE c = code - 0x40u;
	return c <= TAREA;
}

/**********************************************************************//**
 *
 * SJIS ̕\Ȃǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	code	= ʂ镶
 * @return	^Ul
*//***********************************************************************/
bool CSJIS::IsMatch(BYTE code)
{
	if( code > 0xFCu ) return false;
	if( code == 0x7Fu ) return false;
	return true;
}

/**********************************************************************//**
 *
 * SJIS \ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= ʂobt@
 * @param [in]	size		= obt@TCY
 * @param [out]	weight		= d݁ĩGR[fBOƂ̈vx̔rɎg܂j
 * @return	^Ul
*//***********************************************************************/
bool CSJIS::IsMatch(const void* lpBuffer, size_t size, int& weight)
{
	const BYTE*	buf = static_cast<const BYTE*>(lpBuffer);
	weight = 0;

	bool ret = true;
	for( size_t i=0; i < size-1; ++i, ++buf )
	{
		if( IsLeadByte(*buf) )
		{
			++i, ++buf;
			if( CSJIS::IsTrailByte(*buf) )
			{
				weight += 2;
			}
		}
		else
		{
			if( CASCII::IsMatch(*buf) )
			{
				++weight;
			}
			else
			{
				ret = false;
			}
		}
	}
	if( CASCII::IsMatch(*buf) )
	{
		++weight;
	}
	else
	{
		ret = false;
	}
	return ret;
}

/**********************************************************************//**
 *
 * SJIS \ǂ
 *
 * @note	d݂ 1byte ɂ +0(B), +1(_L) , +2(ȓ_)
 *			āAd != size 
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= ʂobt@
 * @param [in]	size		= obt@TCY
 * @param [out]	weight		= d݁ĩGR[fBOƂ̈vx̔rɎg܂j
 * @param [out]	negative	= sv̏d݁ĩGR[fBOƂ̈vx̔rɎg܂j
 * @return	^Ul
*//***********************************************************************/
bool CSJIS::IsMatch(const void* lpBuffer, size_t size, int& weight, int& negative)
{
	const BYTE*	buf = static_cast<const BYTE*>(lpBuffer);
	weight = 0;
	negative = 0;

	for( size_t i=0; i < size-1; ++i, ++buf )
	{
		BYTE ch1 = *buf;
		if( IsLeadByte(ch1) )
		{
			++i, ++buf;
			if( CSJIS::IsTrailByte(*buf) )
			{
				weight += 2;
			}
			else
			{
				negative += 2;
			}
		}
		else
		{
			if( !CASCII::IsMatch(ch1) )
			{
				negative += 2;
			}
			else
			{
				if( ch1 == 0 )
					++negative;	// obt@̓r '\0' ͕sR
			}
		}
	}
	if( CASCII::IsMatch(*buf) )
	{
		++weight;
	}
	else
	{
		negative += 2;
	}
	if( negative > 0 && (negative >= weight) ) return false;
	return true;
}

/**********************************************************************//**
 *
 * SJIS @ˑǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	ch1	= 1byte
 * @param [in]	ch2	= 2byte
 * @return	^Ul
*//***********************************************************************/
bool CSJIS::IsDepend(BYTE ch1, BYTE ch2)
{
	if( !IsLeadByte(ch1) ) return false;
	if( !IsTrailByte(ch2) ) return false;
	WORD code = (ch1<<8)|ch2;

	if( code >= 0x8540 && code <= 0x889e ) return true;
	if( code >= 0xeaa5 ) return true;

	if( ch1 == 0x81 )
	{
		if( (ch2 >= 0xad && ch2 <= 0xb7)
			|| ((ch2 & 0xF8) == 0xc0)	// (ch2 >= 0xc0 && ch2 <= 0xc7)
			|| (ch2 >= 0xcf && ch2 <= 0xd9)
			|| (ch2 >= 0xe9 && ch2 <= 0xef)
			|| ((ch2 & 0xFC) == 0xf8)	// (ch2 >= 0xf8 && ch2 <= 0xfb)
			)
		{
			return true;
		}
	}
	if( ch1 == 0x82 )
	{
		if( (ch2 <= 0x4e)
			|| (ch2 >= 0x59 && ch2 <= 0x5f)
			|| (ch2 >= 0x7a && ch2 <= 0x80)
			|| (ch2 >= 0x9b && ch2 <= 0x9e)
			|| (ch2 >= 0xf2)
			)
		{
			return true;
		}
	}
	if( ch1 == 0x83 )
	{
		BYTE t = ch2 + 1;
		if( ((t & 0xF8) == 0x98)	// (ch2 >= 0x97 && ch2 <= 0x9e)
			|| ((t & 0xF8) == 0xb8)	// (ch2 >= 0xb7 && ch2 <= 0xbe)
			|| (ch2 >= 0xd7)
			)
		{
			return true;
		}
	}
	if( ch1 == 0x81 )
	{
		if( (ch2 >= 0x61 && ch2 <= 0x6f)
			|| (ch2 >= 0x92 && ch2 <= 0x9e)
			|| (ch2 >= 0xbf)
			)
		{
			return true;
		}
	}
	if( ch1 == 0x98 )
	{
		if( (ch2 >= 0x73 && ch2 <= 0x9e)
			)
		{
			return true;
		}
	}
	return false;
}

}	// end of namespace fnd
}	// end of namespace iris
