//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSJIS.h
 * @brief		Shift JIS R[h t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndSJIS_H_
#define INCG_IRIS_FndSJIS_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	Shift JIS (Windows 31J) R[hNX
*/
class CSJIS : public IIrisObject
{
public:

#if 1
	static const BYTE	DAREA	= 120;	//!< ͈̔ (CP932)
#else
	static const BYTE	DAREA	= 94;	//!< ͈̔ (W)
#endif

	static const BYTE	PAREA	= 94;	//!< _͈̔

	static const BYTE	HALF_KANA_BEGIN	= 0xA1u;	//!< pJi
	static const BYTE	HALF_KANA_END	= 0xDFu;	//!< pJi

public:
	// SJIS 2oCg̑1oCgǂ
	static bool	IsLeadByte(BYTE code);
	// SJIS 2oCg̑2oCgǂ
	static bool	IsTrailByte(BYTE code);

public:
	// SJIS ̕\ǂ
	static bool	IsMatch(BYTE code);
	// SJIS ǂ
	static bool	IsMatch(const void* lpBuffer, size_t size, int& weight);
	static bool	IsMatch(const void* lpBuffer, size_t size, int& weight, int& negative);

public:
	// @ˑǂ
	static bool	IsDepend(BYTE ch1, BYTE ch2);
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
