//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndUTF16.h
 * @brief		Unicode R[h t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndUTF16_H_
#define INCG_IRIS_FndUTF16_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	UTF16 R[hNX
*/
class CUTF16 : public IIrisObject
{
public:
	static const u16	BOM	= IRIS_Bytes2WordLE(0xFF, 0xFE);

};

/**
 * @brief	UTF16 BE R[hNX
*/
class CUTF16BE : public IIrisObject
{
public:
	static const u16	BOM	= IRIS_Bytes2WordBE(0xFF, 0xFE);

};

}	// end of namespace fnd
}	// end of namespace iris

#endif
