//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndUTF8.h
 * @brief		UTF8 R[h t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndUTF8_H_
#define INCG_IRIS_FndUTF8_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	UTF8 R[hNX
*/
class CUTF8 : public IIrisObject
{
public:
	// UTF8 }`oCg̑1oCgǂ
	static int	IsLeadByte(BYTE code);
	// UTF8 }`oCg2oCgڈȍ~ǂ
	static bool	IsTrailByte(BYTE code);
	static bool	IsTrailByte(const BYTE* buf, size_t len);

public:
	// UTF8 ̕\ǂ
	static bool	IsMatch(BYTE code);
	// UTF8 ǂ
	static bool	IsMatch(const void* lpBuffer, size_t size, int& weight);
	static bool	IsMatch(const void* lpBuffer, size_t size, int& weight, int& negative);
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
