//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndDES.cpp
 * @brief		DESÍNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndDES_CPP_

//======================================================================
// include
#include "FndDES.h"
#include "fnd/container/FndBits.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// define

//======================================================================
// variable
// S-Boxes:
const unsigned char MODIFIED_SBOX[8][64] = {
	{
	14,  4, 13,  1,  2, 15, 11,  8,  3, 10,  6, 12,  5,  9,  0,  7,
	 0, 15,  7,  4, 14,  2, 13,  1, 10,  6, 12, 11,  9,  5,  3,  8,
	 4,  1, 14,  8, 13,  6,  2, 11, 15, 12,  9,  7,  3, 10,  5,  0,
	15, 12,  8,  2,  4,  9,  1,  7,  5, 11,  3, 14, 10,  0,  6, 13,
	},
	{
	15,  1,  8, 14,  6, 11,  3,  4,  9,  7,  2, 13, 12,  0,  5, 10,
	 3, 13,  4,  7, 15,  2,  8, 14, 12,  0,  1, 10,  6,  9, 11,  5,
	 0, 14,  7, 11, 10,  4, 13,  1,  5,  8, 12,  6,  9,  3,  2, 15,
	13,  8, 10,  1,  3, 15,  4,  2, 11,  6,  7, 12,  0,  5, 14,  9,
	},
	{
	10,  0,  9, 14,  6,  3, 15,  5,  1, 13, 12,  7, 11,  4,  2,  8,
	13,  7,  0,  9,  3,  4,  6, 10,  2,  8,  5, 14, 12, 11, 15,  1,
	13,  6,  4,  9,  8, 15,  3,  0, 11,  1,  2, 12,  5, 10, 14,  7,
	 1, 10, 13,  0,  6,  9,  8,  7,  4, 15, 14,  3, 11,  5,  2, 12,
	},
	{
	 7, 13, 14,  3,  0,  6,  9, 10,  1,  2,  8,  5, 11, 12,  4, 15,
	13,  8, 11,  5,  6, 15,  0,  3,  4,  7,  2, 12,  1, 10, 14,  9,
	10,  6,  9,  0, 12, 11,  7, 13, 15,  1,  3, 14,  5,  2,  8,  4,
	 3, 15,  0,  6, 10,  1, 13,  8,  9,  4,  5, 11, 12,  7,  2, 14,
	},
	{
	 2, 12,  4,  1,  7, 10, 11,  6,  8,  5,  3, 15, 13,  0, 14,  9,
	14, 11,  2, 12,  4,  7, 13,  1,  5,  0, 15, 10,  3,  9,  8,  6,
	 4,  2,  1, 11, 10, 13,  7,  8, 15,  9, 12,  5,  6,  3,  0, 14,
	11,  8, 12,  7,  1, 14,  2, 13,  6, 15,  0,  9, 10,  4,  5,  3,
	},
	{
    12,  1, 10, 15,  9,  2,  6,  8,  0, 13,  3,  4, 14,  7,  5, 11,
    10, 15,  4,  2,  7, 12,  9,  5,  6,  1, 13, 14,  0, 11,  3,  8,
     9, 14, 15,  5,  2,  8, 12,  3,  7,  0,  4, 10,  1, 13, 11,  6,
     4,  3,  2, 12,  9,  5, 15, 10, 11, 14,  1,  7,  6,  0,  8, 13,
	},
	{
     4, 11,  2, 14, 15,  0,  8, 13,  3, 12,  9,  7,  5, 10,  6,  1,
    13,  0, 11,  7,  4,  9,  1, 10, 14,  3,  5, 12,  2, 15,  8,  6,
     1,  4, 11, 13, 12,  3,  7, 14, 10, 15,  6,  8,  0,  5,  9,  2,
     6, 11, 13,  8,  1,  4, 10,  7,  9,  5,  0, 15, 14,  2,  3, 12,
	},
	{
    13,  2,  8,  4,  6, 15, 11,  1, 10,  9,  3, 14,  5,  0, 12,  7,
     1, 15, 13,  8, 10,  3,  7,  4, 12,  5,  6, 11,  0, 14,  9,  2,
     7, 11,  4,  1,  9, 12, 14,  2,  0,  6, 10, 13, 15,  3,  5,  8,
     2,  1, 14,  7,  4, 10,  8, 13, 15, 12,  9,  0,  3,  5,  6, 11,
	},
};

const unsigned char PBOX_PERMUTATION[32] =
{
	16, 7, 20, 21, 29, 12, 28, 17,  1, 15, 23, 26,  5, 18, 31, 10,
	 2, 8, 24, 14, 32, 27,  3,  9, 19, 13, 30,  6, 22, 11,  4, 25
};
//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDES::CDES(void)
{
}

/**********************************************************************//**
 *
 * ̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	pKey	= 
 * @param [in]	size	= z
*//***********************************************************************/
bool CDES::CreateKeys(const u8* pKey, u32 nSize)
{
	static const int KEY_SHIFT[NR] = {1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1};
	static const unsigned char COMPRESSION_PERMUTATION[KSBITS] =
	{
		14, 17, 11, 24,  1,  5,  3, 28, 15,  6, 21, 10,
		23, 19, 12,  4, 26,  8, 16,  7, 27, 20, 13,  2,
		41, 52, 31, 37, 47, 55, 30, 40, 51, 45, 33, 48,
		44, 49, 39, 56, 34, 53, 46, 42, 50, 36, 29, 32
	};

	IRIS_ASSERT( pKey != nullptr );
	IRIS_ASSERT( nSize >= KEYSIZE );
	IRIS_UNUSED_VARIABLE( nSize );

	int koffset=0;
	for( int i=0; i < NR; ++i )
	{
		int ks = KEY_SHIFT[i];
		for( int j=0; j < KEYSIZE; ++j, koffset=(koffset+1)%nSize )
		{
			m_KeySch[i][j] = pKey[koffset];
		}
		u8 x0 = m_KeySch[i][0];
		u8 x2 = m_KeySch[i][2];
		m_KeySch[i][0] = (m_KeySch[i][0] << ks) | ((m_KeySch[i][1] >> (8-ks)) & ((1<<ks)-1));
		m_KeySch[i][1] = (m_KeySch[i][1] << ks) | ((m_KeySch[i][2] >> (8-ks)) & ((1<<ks)-1));
		m_KeySch[i][2] = ((m_KeySch[i][2] & 0xF0)  << ks) | (((x0 >> (8-ks)) & ((1<<ks)-1)) << 4);
		m_KeySch[i][2] |= (((x2 & 0xF)  << ks) & 0xF) | ((m_KeySch[i][3] >> (8-ks)) & ((1<<ks)-1));
		m_KeySch[i][3] = (m_KeySch[i][3] << ks) | ((m_KeySch[i][4] >> (8-ks)) & ((1<<ks)-1));
		m_KeySch[i][4] = (m_KeySch[i][4] << ks) | ((x2 >> (4-ks)) & ((1<<ks)-1));

		for( int idx=0, j=0; j < KS_LENGTH; ++j )
		{
			m_KeySch[i][j] = 0;
			for( int k=0; k < 8; ++k, ++idx )
			{
				int ki = COMPRESSION_PERMUTATION[idx]-1;
				m_KeySch[i][j] |= ((m_KeySch[i][ki/8] >> (ki & (8-1))) & 0x1) << (7-k);
			}
		}

	}
	return true;
}

/**********************************************************************//**
 *
 * Í
 *
 -----------------------------------------------------------------------
 * @param [out]	dst	= o̓obt@[BLOCKSIZE]
 * @param [in]	src	= ̓obt@[BLOCKSIZE]
*//***********************************************************************/
bool CDES::EncryptBlock(u8* dst, const u8* src)
{
	IRIS_ASSERT( dst != nullptr );
	IRIS_ASSERT( src != nullptr );

	static const int BKSIZE_H = BLOCKSIZE/2;
	fnd::CBitsFlag<KSBITS, u8> sb;
	u8 pb[BKSIZE_H];
	u8 pbox[BKSIZE_H];

	for( int i=0; i < BLOCKSIZE; ++i ) dst[i] = src[i];

	for( int r=0; r < NR; ++r )
	{
		{
			sb[0] = (((src[BKSIZE_H+3] & 0x01) << 7) | ((src[BKSIZE_H  ] & 0xF8) >> 1) | ((src[BKSIZE_H  ] & 0x18) >> 3)) ^ m_KeySch[r][0];
			sb[1] = (((src[BKSIZE_H  ] & 0x07) << 5) | ((src[BKSIZE_H+1] & 0x80) >> 3) | ((src[BKSIZE_H  ] & 0x01) << 3) | ((src[BKSIZE_H+1] & 0xE0) >> 5) ) ^ m_KeySch[r][1];
			sb[2] = (((src[BKSIZE_H+1] & 0x18) << 3) | ((src[BKSIZE_H+1] & 0x1F) << 1) | ((src[BKSIZE_H+2] & 0x80) >> 7) ) ^ m_KeySch[r][2];
			sb[3] = (((src[BKSIZE_H+1] & 0x01) << 7) | ((src[BKSIZE_H+2] & 0xF8) >> 1) | ((src[BKSIZE_H+2] & 0x18) >> 3) ) ^ m_KeySch[r][3];
			sb[4] = (((src[BKSIZE_H+2] & 0x07) << 5) | ((src[BKSIZE_H+3] & 0x80) >> 3) | ((src[BKSIZE_H+2] & 0x01) << 3) | ((src[BKSIZE_H+3] & 0xE0) >> 5) ) ^ m_KeySch[r][4];
			sb[5] = (((src[BKSIZE_H+3] & 0x18) << 3) | ((src[BKSIZE_H+3] & 0x1F) << 1) | ((src[BKSIZE_H  ] & 0x80) >> 7) ) ^ m_KeySch[r][5];
		}

		for( int i=0; i < BKSIZE_H; ++i )
		{
#define sb_index(n)	((sb.GetBit(n)<<(5+2)) | (sb.GetBit(n+5)<<(4+2))	\
	| (sb.GetBit(n+1)<<(3+2)) | (sb.GetBit(n+2)<<(2+2)) | (sb.GetBit(n+3)<<(1+2)) | (sb.GetBit(n+4)<<(0+2)))
			int idxh = sb_index(i*12);
			int idxl = sb_index(i*12+6);
			pb[i] = 0;
			pb[i] |= IRIS_FLG8_BIT( MODIFIED_SBOX[i*2], idxh ) << 7;
			pb[i] |= IRIS_FLG8_BIT( MODIFIED_SBOX[i*2], idxh ) << 6;
			pb[i] |= IRIS_FLG8_BIT( MODIFIED_SBOX[i*2], idxh ) << 5;
			pb[i] |= IRIS_FLG8_BIT( MODIFIED_SBOX[i*2], idxh ) << 4;
			pb[i] |= IRIS_FLG8_BIT( MODIFIED_SBOX[i*2+1], idxl ) << 3;
			pb[i] |= IRIS_FLG8_BIT( MODIFIED_SBOX[i*2+1], idxl ) << 2;
			pb[i] |= IRIS_FLG8_BIT( MODIFIED_SBOX[i*2+1], idxl ) << 1;
			pb[i] |= IRIS_FLG8_BIT( MODIFIED_SBOX[i*2+1], idxl ) << 0;
		}

		for( int idx=0, i=0; i < BKSIZE_H; ++i )
		{
			for( int k=0; k < 8; ++k, ++idx )
			{
				int ki = PBOX_PERMUTATION[idx]-1;
				pbox[i] |= IRIS_FLG8_BIT(pb, ki) << (7-k);
			}
		}

		if( r < NR-1 )
		{
			for( int i=0; i < BKSIZE_H; ++i )
			{
				u8 x = dst[BKSIZE_H + i];
				dst[BKSIZE_H + i] = dst[i] ^ pbox[i];
				dst[i] = x;
			}
		}
		else
		{
			for( int i=0; i < BKSIZE_H; ++i )
			{
				dst[i] = dst[i] ^ pbox[i];
			}
		}
	}
	return true;
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [out]	dst	= o̓obt@[BLOCKSIZE]
 * @param [in]	src	= ̓obt@[BLOCKSIZE]
*//***********************************************************************/
bool CDES::DecryptBlock(u8* dst, const u8* src)
{
	IRIS_ASSERT( dst != nullptr );
	IRIS_ASSERT( src != nullptr );
	IRIS_ASSERT( dst != nullptr );
	IRIS_ASSERT( src != nullptr );

	static const int BKSIZE_H = BLOCKSIZE/2;
	fnd::CBitsFlag<KSBITS, u8> sb;
	u8 pb[BKSIZE_H];
	u8 pbox[BKSIZE_H];

	for( int i=0; i < BLOCKSIZE; ++i ) dst[i] = src[i];

	for( int r=NR-1; r >= 0; --r )
	{
		{
			sb[0] = (((src[BKSIZE_H+3] & 0x01) << 7) | ((src[BKSIZE_H  ] & 0xF8) >> 1) | ((src[BKSIZE_H  ] & 0x18) >> 3)) ^ m_KeySch[r][0];
			sb[1] = (((src[BKSIZE_H  ] & 0x07) << 5) | ((src[BKSIZE_H+1] & 0x80) >> 3) | ((src[BKSIZE_H  ] & 0x01) << 3) | ((src[BKSIZE_H+1] & 0xE0) >> 5) ) ^ m_KeySch[r][1];
			sb[2] = (((src[BKSIZE_H+1] & 0x18) << 3) | ((src[BKSIZE_H+1] & 0x1F) << 1) | ((src[BKSIZE_H+2] & 0x80) >> 7) ) ^ m_KeySch[r][2];
			sb[3] = (((src[BKSIZE_H+1] & 0x01) << 7) | ((src[BKSIZE_H+2] & 0xF8) >> 1) | ((src[BKSIZE_H+2] & 0x18) >> 3) ) ^ m_KeySch[r][3];
			sb[4] = (((src[BKSIZE_H+2] & 0x07) << 5) | ((src[BKSIZE_H+3] & 0x80) >> 3) | ((src[BKSIZE_H+2] & 0x01) << 3) | ((src[BKSIZE_H+3] & 0xE0) >> 5) ) ^ m_KeySch[r][4];
			sb[5] = (((src[BKSIZE_H+3] & 0x18) << 3) | ((src[BKSIZE_H+3] & 0x1F) << 1) | ((src[BKSIZE_H  ] & 0x80) >> 7) ) ^ m_KeySch[r][5];
		}

		for( int i=0; i < BKSIZE_H; ++i )
		{
#define sb_index(n)	((sb.GetBit(n)<<(5+2)) | (sb.GetBit(n+5)<<(4+2))	\
	| (sb.GetBit(n+1)<<(3+2)) | (sb.GetBit(n+2)<<(2+2)) | (sb.GetBit(n+3)<<(1+2)) | (sb.GetBit(n+4)<<(0+2)))
			int idxh = sb_index(i*12);
			int idxl = sb_index(i*12+6);
			pb[i] = 0;
			pb[i] |= IRIS_FLG8_BIT( MODIFIED_SBOX[i*2], idxh ) << 7;
			pb[i] |= IRIS_FLG8_BIT( MODIFIED_SBOX[i*2], idxh ) << 6;
			pb[i] |= IRIS_FLG8_BIT( MODIFIED_SBOX[i*2], idxh ) << 5;
			pb[i] |= IRIS_FLG8_BIT( MODIFIED_SBOX[i*2], idxh ) << 4;
			pb[i] |= IRIS_FLG8_BIT( MODIFIED_SBOX[i*2+1], idxl ) << 3;
			pb[i] |= IRIS_FLG8_BIT( MODIFIED_SBOX[i*2+1], idxl ) << 2;
			pb[i] |= IRIS_FLG8_BIT( MODIFIED_SBOX[i*2+1], idxl ) << 1;
			pb[i] |= IRIS_FLG8_BIT( MODIFIED_SBOX[i*2+1], idxl ) << 0;
		}

		for( int idx=0, i=0; i < BKSIZE_H; ++i )
		{
			for( int k=0; k < 8; ++k, ++idx )
			{
				int ki = PBOX_PERMUTATION[idx]-1;
				pbox[i] |= IRIS_FLG8_BIT(pb, ki) << (7-k);
			}
		}

		if( r > 0 )
		{
			for( int i=0; i < BKSIZE_H; ++i )
			{
				u8 x = dst[BKSIZE_H + i];
				dst[BKSIZE_H + i] = static_cast<u8>(dst[i] ^ pbox[i]);
				dst[i] = x;
			}
		}
		else
		{
			for( int i=0; i < BKSIZE_H; ++i )
			{
				dst[i] = static_cast<u8>(dst[i] ^ pbox[i]);
			}
		}
	}
	return true;
}

}	// end of namespace fnd
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "../../unit/UnitCore.h"
#include "../../iris_iostream.h"
#include <string.h>
#include "../../iris_using.h"

#define ALL_TEST

//======================================================================
// test
IRIS_UNITTEST(CFndDESUnitTest, Func)
{
	while( 1 )
	{
		CDES des;
		char c[CDES::BLOCKSIZE*16] = "test";
		char ck[CDES::KEYSIZE+1] = "0123456";
		u8 key[CDES::KEYSIZE];
		memcpy(key, ck, sizeof(key));

		// ÍL[
		des.CreateKeys(key, sizeof(key));

#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
		std::cout << "͂ĂB" << std::endl;
		std::cin >> c;
#endif

		des.Encrypt((u8*)c, (u8*)c, sizeof(c));
		//char m[CCipher::BLOCKSIZE*16+1];
		//memcpy(m, c, sizeof(c));
		//m[CCipher::BLOCKSIZE*16] = '\0';
		//std::cout << m << std::endl;

		des.Decrypt((u8*)c, (u8*)c, sizeof(c));

		std::cout << c << std::endl;

#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
		s32 flag=0;
		std::cout << "Iꍇ́A0 ͂ĂB" << std::endl;
		std::safe_cin >> flag;
		if( flag == 0 ) break;
#else
		break;
#endif
	}
}

#endif // #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
