//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndAccessor.h
 * @brief		|C^ANZXNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndAccessor_H_
#define INCG_IRIS_FndAccessor_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	|C^ANZXNX
 * @details	(@ref section_autoexp_CAccessor "autoexp")
 * @tparam	_TN	= ^
*/
template<typename _TN>
class CAccessor : private INonCopyable< CAccessor<_TN> >
{
	typedef _TN		value_type;
	typedef _TN		*value_ptr;
	typedef _TN		&value_ref;

	value_ptr	m_ptr;
public:
	/// RXgN^
	CAccessor(value_ptr ptr) : m_ptr(ptr) {}

public:
	/// ANZX
	value_ref	outer(void)		{ return *m_ptr; }
	/// |C^ANZX
	value_ptr	outer_ptr(void)	{ return m_ptr; }

public:
	//
	value_ptr	operator -> (void)	{ return m_ptr; }
};

}	// end of namespace fnd
}	// end of namespace iris

/**
 * @addtogroup	autoexp
 * @{
 * @addtogroup	Visualizer
 * @section		section_autoexp_CAccessor	; iris::fnd::CAccessor
 * @code
;------------------------------------------------------------------------------
; iris::fnd::CAccessor
;------------------------------------------------------------------------------
iris::fnd::CAccessor<*> {
	preview
	(
		#if ($e.m_ptr == 0 ) (
			"?"
		) #else (
			*$e.m_ptr
		)
	)
}
 * @endcode
 * @}
*/

#endif
