//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndBinder.h
 * @brief		eqANX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndBinder_H_
#define INCG_IRIS_FndBinder_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace fnd
{

/**
 * @brief	Ď҃NX
 * @note	݂ɊĎNX
 * @tparam	_TN	= Ď
*/
template<typename _TN>
class CBinder : private INonCopyable<>
{
	typedef _TN		value_type;
	typedef _TN		*value_ptr;
	typedef _TN		&value_ref;

public:
	// Ď҃NX
	class CPaper : private INonCopyable<CPaper>
	{
		friend	class CBinder<_TN>;
		typedef CBinder<_TN>	_Binder;
		_Binder*	m_binder;
	public:
		/**
		 * @brief	RXgN^
		*/
		CPaper(void)
			: m_binder(nullptr)
		{
		}
		/**
		 * @brief	fXgN^
		*/
		virtual ~CPaper(void)
		{
			if( m_binder != nullptr )
			{
				m_binder->free(this);
			}
		}
		/**
		 * @brief	o^ς݂ǂ
		 * @return	^Ul
		*/
		bool	is_bind(void)	const
		{
			return m_binder != nullptr;
		}
	};
	typedef CPaper	*paper_ptr;
private:
	value_ptr	m_ptr;	//!< Ď
public:
	/**
	 * @brief	RXgN^
	*/
	CBinder(void)
		: m_ptr(nullptr)
	{
	}
	/**
	 * @brief	fXgN^
	 *
	*/
	virtual ~CBinder(void)
	{
		free(m_ptr);
	}
public:
	/**
	 * @brief	o^
	 * @param [in]	ptr = |C^
	*/
	void	bind(value_ptr ptr)
	{
		free(m_ptr);
		m_ptr = ptr;
		if( ptr != nullptr )
		{
			ptr->m_binder = this;
		}
	}
	/**
	 * @brief	
	 * @param [in]	ptr	= |C^
	*/
	void	free(paper_ptr ptr)
	{
		if( ptr == nullptr ) return;
		if( ptr == m_ptr )
		{
			ptr->m_binder = nullptr;
			m_ptr = nullptr;
		}
	}
	/**
	 * 󂩂ǂ
	 * @return	^Ul
	*/
	bool	empty(void)	const
	{
		return m_ptr == nullptr;
	}

public:
	/**
	 * @brief	Ď҂̎擾
	 * @return	|C^
	*/
	value_ptr	ptr(void)
	{
		return m_ptr;
	}
	/**
	 * @brief	Ď҂̎擾
	 * @return	|C^
	*/
	const value_ptr	ptr(void) const
	{
		return m_ptr;
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
