//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndBits.h
 * @brief		rbgϐ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndBits_H_
#define INCG_IRIS_FndBits_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../ml/iml_math.hpp"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// bit ϐ
template<typename _TN>
class CBits : public IIrisObject
{
	typedef CBits<_TN>	_Myt;
	typedef _TN	value_type;
private:
	value_type	m_value;
public:

	/// RXgN^
	CBits(void) : m_value(0) {}
	/// RXgN^
	CBits(value_type val) : m_value(val) {}

public:
	/**
	 * @name operator
	 * @{
	*/
	operator		value_type	(void)			{ return m_value; }
	operator const	value_type	(void)	const	{ return m_value; }

public:
	_Myt&	operator	=	(value_type val)	{ m_value = val; return *this; }
	_Myt&	operator	+=	(value_type val)	{ m_value += val; return *this; }
	_Myt&	operator	-=	(value_type val)	{ m_value -= val; return *this; }
	_Myt&	operator	|=	(value_type val)	{ m_value |= val; return *this; }
	_Myt&	operator	&=	(value_type val)	{ m_value &= val; return *this; }
	_Myt&	operator	^=	(value_type val)	{ m_value ^= val; return *this; }
	/**
	 * @}
	*/

public:
	bool	IsBits(value_type val)		const	{ return IRIS_TO_bool(m_value & val); }
	bool	IsEqualBits(value_type val)	const	{ return (m_value & val) == val; }

public:
	void		SetBits(value_type val)				{ m_value = val; }
	value_type	GetBits(void)			const		{ return m_value; }

public:
	void	EnableBits(value_type val)						{ m_value |= val; }
	void	DisableBits(value_type val)						{ m_value &= ~val; }
	void	SetBits(value_type val, bool enable)			{ enable ? EnableBits(val) : DisableBits(val); }
	void	EnableMaskBits(value_type mask, value_type val)	{ DisableBits(mask); EnableBits(mask & val); }
	void	Clear(void)										{ m_value = 0; }
};

//! bittONX
template<u32 BITS=32, typename TN=u32>
class CBitsFlag : public IIrisObject
{
	enum
	{
		ALIGN		= sizeof(TN),
		ALIGN_BITS	= ALIGN * 8,
		SHIFT		= iml::static_log2<ALIGN_BITS>::value,	//!< Vtg
		MASK		= ALIGN_BITS-1,
		ARRAY_SIZE	= (BITS+ALIGN_BITS-1)/ALIGN_BITS		//!< zTCY
	};
public:
	typedef TN		value_type;
	typedef TN		*value_ptr;
	typedef TN		&value_ref;
private:
	value_type		m_Flags[ARRAY_SIZE];
public:
	/// RXgN^
	CBitsFlag(void)
	{
		IRIS_STATIC_ASSERT( ARRAY_SIZE > 0 );
		memset(m_Flags, 0, sizeof(m_Flags));
	}
	/// fXgN^
	~CBitsFlag(void)	{}

public:
	value_type	operator [] (int nIndex) const				{ return GetFlag(nIndex); }
	value_ref	operator [] (int nIndex)					{ return GetFlag(nIndex); }

public:
	/// tOON
	CBitsFlag&	EnableFlag(int nOffset)					{ m_Flags[nOffset >> SHIFT] |= 1<<(nOffset&MASK); return *this; }
	/// tOON
	CBitsFlag&	EnableFlag(int nIndex, u32 bit)			{ m_Flags[nIndex] |= bit; return *this; }

	/// tOOFF
	CBitsFlag&	DisableFlag(int nOffset)				{ m_Flags[nOffset >> SHIFT] &= ~(1<<(nOffset&MASK)); return *this; }
	/// tOOFF
	CBitsFlag&	DisableFlag(int nIndex, u32 bit)		{ m_Flags[nIndex] &= ~bit; return *this; }

	/// tO`FbN
	bool		IsFlag(int nOffset)			const		{ return ((m_Flags[nOffset >> SHIFT] & (1<<(nOffset&MASK))) != 0); }
	/// tO`FbN
	bool		IsFlag(int nIndex, u32 bit)	const		{ return ((m_Flags[nIndex] & bit) != 0); }

	/// tOZbg
	CBitsFlag&	SetFlag(int nOffset, bool enable)			{ enable ? EnableFlag(nOffset) : DisableFlag(nOffset); return *this; }
	/// tOZbg
	CBitsFlag&	SetFlag(int nIndex, u32 bit, bool enable)	{ enable ? EnableFlag(nIndex, bit) : DisableFlag(nIndex, bit); return *this; }

	/// tORs[
	void		CopyFlag(int nIndex, u32 flag)			{ m_Flags[nIndex] = flag; }
	/// tONA
	void		ClearFlag(int nIndex)					{ m_Flags[nIndex] = 0; }
	/// tONA
	void		ClearFlag(void)							{ memset(m_Flags, 0, sizeof(m_Flags)); }

	/// rbgQ
	BOOL		GetBit(int nOffset)		const			{ return (m_Flags[nOffset >> SHIFT] >> (nOffset&MASK)) & 0x1; }

	/// tOQ
	value_type	GetFlag(int nIndex)		const			{ return m_Flags[nIndex]; }
	value_ref	GetFlag(int nIndex)						{ return m_Flags[nIndex]; }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
