//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndIterator.h
 * @brief		Ce[^ev[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndIterator_H_
#define INCG_IRIS_FndIterator_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
template<class Base, typename TN, typename Ref, typename Ptr>class CIterator;

//======================================================================
// class
/**
 * @brief  Ce[^ev[gNX
 * @tparam	Node	m[h^
*/
template<typename Node>
class IIteratorBase : public IIrisObject
{
	typedef IIteratorBase<Node>	_Myt;
protected:
	typedef	Node	node_type;
	typedef	Node	*node_ptr;

public:
	typedef Node	value_type;
	typedef Node	*pointer;
	typedef Node	&reference;

protected:
	node_ptr	m_pNode;	//!< m[h
public:
	// RXgN^
	IIteratorBase(void)	: m_pNode(nullptr) {}
	IIteratorBase(node_ptr node) : m_pNode(node) {}

protected:
	/// ̃m[hɐi߂
//	virtual void	inc(void) = 0;
	/// Õm[hɖ߂
//	virtual void	dec(void) = 0;
};

	/**
 * @brief  Ce[^ev[gNX
 * @tparam	Base	Ce[^x[X
 * @tparam	TN		f[^^
 * @tparam	Ref		Qƌ^
 * @tparam	Ptr		|C^^
*/
template<class Base, typename TN, typename Ref=TN&, typename Ptr=TN*>
class CIterator : public Base
{
	typedef Base							_Mybase;
	typedef	CIterator<Base, TN, Ref, Ptr>	_Myt;
//	using typename Base::node_ptr;
	typedef	typename Base::node_ptr	node_ptr;
public:
	typedef	CIterator<Base, TN, TN&, TN*>				iterator;
	typedef	CIterator<Base, TN, const TN&, const TN*>	const_iterator;
	typedef	CIterator<Base, TN, Ref, Ptr>				self;

	typedef	TN		value_type;
	typedef	TN		*value_ptr;
	typedef	TN		&value_ref;
public:
	/// RXgN^
	CIterator(void){}
	CIterator(node_ptr np) : _Mybase(np) {}
	CIterator(const iterator& it) : _Mybase(it) {}

	/// Iy[^
	s32			operator == (const TN& rhs)			const { return *static_cast<value_ptr>(this->m_pNode) == rhs; }
	s32			operator == (const node_ptr ptr)	const { return this->m_pNode == ptr; }
	s32			operator == (const _Myt& it)		const { return this->m_pNode == it.m_pNode; }
	s32			operator != (const _Myt& it)		const { return this->m_pNode != it.m_pNode; }
	value_ref	operator *	() const	{ return *(static_cast<value_ptr>(this->m_pNode)); }
	value_ptr	operator &	() const	{ return static_cast<value_ptr>(this->m_pNode); }
	value_ptr	operator -> () const	{ return static_cast<value_ptr>(this->m_pNode); }
	self&		operator ++ ()			{ this->inc(); return *this; }
	self		operator ++ (int)		{ self tmp = *this; this->inc(); return tmp; }
	self&		operator -- ()			{ this->dec(); return *this; }
	self		operator -- (int)		{ self tmp = *this; this->dec(); return tmp; }

	/// k
	static const _Myt null(void)	{ return static_cast<node_ptr>(nullptr); }
};


}	// end of namespace fnd
}	// end of namespace iris

#endif
