//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndLiberator.h
 * @brief		|C^{NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndLiberator_H_
#define INCG_IRIS_FndLiberator_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
class CLiberator;
template<class _TC>class CLiberatorCRTP;
template<typename _TN>class CLiberatorObject;

//======================================================================
// class
//! |C^{NX
class CLiberator : public IIrisObject
{
public:
	typedef void		value_type;
	typedef value_type*	value_ptr;

protected:
	value_ptr	m_ptr;	//!< ǗAhX

public:
	/// RXgN^
	CLiberator(value_ptr p=nullptr) : m_ptr(p)	{}
	/// fXgN^
	virtual ~CLiberator(void)	{ liberate(); }

public:
	/// 
	//CLiberator&			operator = (value_ptr p)	{ m_ptr = p; return *this; }

	/// A[
	value_ptr			operator -> (void)	const	{ return m_ptr; }

	/// |C^ANZX
	value_ptr			ptr(void)	const			{ return m_ptr; }

public:
	/// ֐
	void	liberate( void )
	{
		// |C^ : ȂɂȂ
		m_ptr = nullptr;
	}
};

/**
 * @brief	CRTP𗘗p|C^{NX
 * @details	(@ref section_autoexp_CLiberatorObject "autoexp")
 * @tparam	_TC	= Ώی^
*/
template<class _TC>
class CLiberatorCRTP : public CLiberator
{
public:
	/// RXgN^
	CLiberatorCRTP(CLiberator::value_ptr p=nullptr) : CLiberator(p)	{}
public:
	/// ֐
	void	liberate( void )
	{
		if( m_ptr != nullptr )
		{
			m_ptr = _TC::do_liberate(m_ptr);
		}
	}
private:
	/// ֐(CRTP call p)
	static void*	do_liberate(void* /*p*/)
	{
		// |C^ : ȂɂȂ
		return nullptr;
	}
};

/**
 * @brief	IuWFNgp|C^{NX
 * @details	(@ref section_autoexp_CLiberatorObject "autoexp")
 * @tparam	_TN	= Ώی^
*/
template<typename _TN>
class CLiberatorObject : public CLiberator
{
	typedef CLiberatorObject<_TN>	_Myt;
public:
	typedef _TN			value_type;
	typedef value_type*	value_ptr;

public:
	/// RXgN^
	CLiberatorObject(value_ptr p=nullptr) : CLiberator(p)	{}
	/// fXgN^
	virtual ~CLiberatorObject(void)	{ liberate(); }

public:
	/// A[
	value_ptr			operator -> (void)	const	{ return static_cast<value_ptr>(m_ptr); }

	/// |C^ANZX
	value_ptr			ptr(void)	const			{ return static_cast<value_ptr>(m_ptr); }

public:
	/**
	 * @brief	֐
	 * @note	delete
	*/
	void	liberate( void )
	{
		if( this->m_ptr != nullptr )
		{
			value_ptr p = (static_cast<value_ptr>(this->m_ptr));
			IRIS_SAFE_DELETE(p);
			m_ptr = nullptr;
		}
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif

/**
 * @addtogroup	autoexp
 * @{
 * @addtogroup	Visualizer
 * @section		section_autoexp_CLiberatorObject	; iris::fnd::CLiberatorObject
 * @code
;------------------------------------------------------------------------------
; iris::fnd::CLiberatorObject, iris::fnd::CLiberatorObject
;------------------------------------------------------------------------------
iris::fnd::CLiberatorObject<*>|iris::fnd::CLiberatorCRTP<*> {
	children
	(
		#(
			[actual members]: [$e,!],
			m_ptr : ($T1*)($e.m_ptr)
		)
	)
	preview
	(
		$e.m_ptr
	)
}
 * @endcode
 * @}
*/
