//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSafeBool.h
 * @brief		S bool ^ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndSafeBool_H_
#define INCG_IRIS_FndSafeBool_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{


namespace detail
{

	/**
	 * @internal
	 * @brief	S bool ^x[XNX
	*/
	class CSafeBoolBase : public IIrisObject
	{
	public:
		typedef void (CSafeBoolBase::*bool_type)(void) const;
		void not_support_comparisons(void)	const {}
	protected:
		CSafeBoolBase(void) {}
		CSafeBoolBase(const CSafeBoolBase&) {}
		CSafeBoolBase& operator = (const CSafeBoolBase&) { return *this; }
		~CSafeBoolBase(void) {}
	};

}	// end of namespace detail


/**
 * @brief	CRTP  safe_bool
 * @tparam _TC	= boolean_test ^
*/
template<class _TC=void>
class CSafeBool : private iris::detail::CSafeBoolBase
{
public:
	operator bool_type (void)	const
	{
		return (static_cast<const _TC*>(this))->boolean_test() ?
			&CSafeBoolBase::not_support_comparisons : 0;
	}
protected:
	~CSafeBool(void);
};

/**
 * @brief	z֐  safe_bool
*/
template<>
class CSafeBool<void> : private iris::detail::CSafeBoolBase
{
public:
	operator bool_type (void)	const
	{
		return boolean_test() ?
			&CSafeBoolBase::not_support_comparisons : 0;
	}
protected:
	virtual bool boolean_test() const = 0;
	virtual ~CSafeBool(void);
};

template<class _TC>
bool operator == (const CSafeBool<_TC>& lhs, bool rhs)
{
	bool b = false;
	if( lhs ) b = true;
	return b == rhs;
}
template<class _TC>
bool operator == (bool lhs, const CSafeBool<_TC>& rhs)
{
	bool b = false;
	if( rhs ) b = true;
	return b == lhs;
}

template<class _TC1, class _TC2>
void operator == (const CSafeBool<_TC1>& lhs, const CSafeBool<_TC2>& rhs)
{
	lhs.not_support_comparisons();
}
template<class _TC1, class _TC2>
void operator != (const CSafeBool<_TC1>& lhs, const CSafeBool<_TC2>& rhs)
{
	lhs.not_support_comparisons();
}

}	// end of namespace fnd
}	// end of namespace iris

#endif
