//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSingleton.h
 * @brief		VOgx[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndSingleton_H_
#define INCG_IRIS_FndSingleton_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	VOgx[XNX
 * @tparam	TN_			= Ώی^
 * @tparam	NUM_INST_	= CX^X̌
*/
template<typename TN_, u32 NUM_INST_=1>
class CSingleton : private INonCopyable<>
{
	IRIS_STATIC_ASSERT( NUM_INST_ > 0 );

public:
	static const u32	NUM_INST = NUM_INST_;
public:
	typedef TN_			value_type;
	typedef TN_			*value_ptr;
	typedef TN_			&value_ref;
private:
	s32	m_idx;	//!< CX^XCfbNX

public:
	/// CX^X̗L
	static bool			is_valid(s32 idx=0)			{ return (ptr(idx) != nullptr); }
	/// CX^X̎擾
	static value_ref	GetInstance(s32 idx=0)		{ IRIS_ASSERT( ptr(idx) != nullptr ); return *ptr(idx); }
	/// CX^XAhX̎擾
	static value_ptr	GetInstancePtr(s32 idx=0)	{ return ptr(idx); }

protected:
	/// RXgN^
	CSingleton(s32 idx=0)
		: m_idx(idx)
	{
		IRIS_ASSERT( ptr(idx) == nullptr );
		s32w64 ofs = (s32w64)(value_ptr)1 - (s32w64)(CSingleton<value_type>*)(value_ptr)1;
		ptr(idx) = (value_ptr)((s32w64)this + ofs);
	}
	/// fXgN^
	~CSingleton(void)
	{
		ptr(m_idx) = nullptr;
		m_idx = NUM_INST;
	}

private:
#if 0
	// [J static 
	static volatile value_ptr& ptr(s32 idx)
	{
IRIS_MSC_PRAGMA_WARNING_BEGIN()
IRIS_MSC_PRAGMA_WARNING_DISABLE(4640)	//	[J X^eBbN IuWFNg̍\zXbh Z[tł͂܂
		static value_ptr s_instance[NUM_INST] = { nullptr };
IRIS_MSC_PRAGMA_WARNING_END()

		IRIS_ASSERT( idx < NUM_INST );
		return s_instance[idx];
	}
#else
	static volatile value_ptr& ptr(s32 idx)
	{
		IRIS_ASSERT( idx < NUM_INST );
		return s_instance[idx];
	}
	static value_ptr s_instance[NUM_INST];
#endif
};

template<typename TN_, u32 NUM_INST_>
TN_*	CSingleton<TN_, NUM_INST_>::s_instance[NUM_INST] = { nullptr };

/**
 * @brief	VOgx[XNX
 * @tparam	TN_			= Ώی^
 * @tparam	NUM_INST_	= CX^X̌
*/
template<typename TN_, u32 NUM_INST_=1>
class CSingletonCRTP : private INonCopyable<>
{
	IRIS_STATIC_ASSERT( NUM_INST_ > 0 );
public:
	static const u32	NUM_INST = NUM_INST_;

public:
	typedef TN_			value_type;
	typedef TN_			*value_ptr;
	typedef TN_			&value_ref;

public:
	/// CX^X̎擾
	static value_ref	GetInstance(s32 idx=0)		{ return value_type::GetInstance_(idx); }

protected:
	static value_ref	GetInstance_(s32 idx=0)		{ static value_type instance[NUM_INST]; return instance[idx]; }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
