//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndTemplateNode.h
 * @brief		؍\NXtemplatem[hNXx[Xt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndTemplateNode_H_
#define INCG_IRIS_FndTemplateNode_H_

//======================================================================
// include
#include "FndLiberator.h"
#include "../../c++0x/cpp0x_type_traits.hpp"
#include "../../ml/iml_type_select.hpp"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	؍\NXtemplatem[hx[X
 * @tparam	TN_			= Ώی^
 * @tparam	NodeBase	= m[h^
*/
template< typename TN_, class NodeBase >
class CTemplateNode : public NodeBase
{
	typedef CTemplateNode<TN_, NodeBase>	_Myt;
public:
	typedef	TN_		value_type;
	typedef	TN_*	value_ptr;
	typedef	TN_&	value_ref;
	typedef const TN_&	const_ref;
	typedef typename ::cpp0x::arg_type<TN_>::type arg_type;	//!< ^
private:
	value_type	m_value;
public:
	/// RXgN^
	CTemplateNode(arg_type val) : m_value(val)	{}
	/// RXgN^
	CTemplateNode(void)	: m_value(0)		{}
	/// fXgN^
	virtual ~CTemplateNode(void)	{}

	// Iy[^
	value_ref		operator *	()			{ return m_value; }
	const_ref		operator *	() const	{ return m_value; }
	value_type		operator -> () const	{ return m_value; }

	bool			operator == (const TN_&  rhs) const	{ return m_value == rhs; }
	bool			operator == (const _Myt& rhs) const	{ return m_value == *rhs; }
	bool			operator != (const _Myt& rhs) const	{ return m_value != *rhs; }
	bool			operator <  (const _Myt& rhs) const	{ return m_value <  *rhs; }
	bool			operator <= (const _Myt& rhs) const	{ return m_value <= *rhs; }
	bool			operator >  (const _Myt& rhs) const	{ return m_value >  *rhs; }
	bool			operator >= (const _Myt& rhs) const	{ return m_value >= *rhs; }
	_Myt&			operator =  (arg_type  rhs)   		{ m_value = rhs; return *this; }

	/// l擾
	value_ref		value(void)					{ return m_value; }
	const_ref		value(void)	const			{ return m_value; }
	/// |C^̐ݒ(Nς݂̃m[h͑łȂ)
	void			set(arg_type val)			{ IRIS_ASSERT(!this->is_link()); m_value = val; }
};

/**
 * @brief	؍\NXtemplatem[hx[X(Liberatort)
 * @tparam	TN_			= Ώی^
 * @tparam	NodeBase	= m[h^
 * @tparam	Liberator	= NX^
*/
template< typename TN_, class NodeBase, class Liberator=CLiberatorObject<TN_> >
class CTemplateLiberateNode : public NodeBase, public Liberator
{
	typedef CTemplateLiberateNode<TN_, NodeBase, Liberator>	_Myt;
public:
	typedef	TN_		value_type;
	typedef	TN_*	value_ptr;
	typedef	TN_&	value_ref;
public:
	/// RXgN^
	explicit CTemplateLiberateNode(value_ptr p) : Liberator(p)	{}
	/// RXgN^
	CTemplateLiberateNode(void)	: Liberator(nullptr)		{}
	/// fXgN^
	virtual ~CTemplateLiberateNode(void)	{ this->liberate(); }

	// Iy[^
	value_ref		operator *	() const	{ return *(static_cast<value_ptr>(this->m_ptr)); }
	value_ptr		operator -> () const	{ return static_cast<value_ptr>(this->m_ptr); }

	bool			operator == (const _Myt& rhs) const	{ return *(static_cast<value_ptr>(this->m_ptr)) == *rhs; }
	bool			operator != (const _Myt& rhs) const	{ return *(static_cast<value_ptr>(this->m_ptr)) != *rhs; }
	bool			operator <  (const _Myt& rhs) const	{ return *(static_cast<value_ptr>(this->m_ptr)) < *rhs; }
	bool			operator <= (const _Myt& rhs) const	{ return *(static_cast<value_ptr>(this->m_ptr)) <= *rhs; }
	bool			operator >  (const _Myt& rhs) const	{ return *(static_cast<value_ptr>(this->m_ptr)) > *rhs; }
	bool			operator >= (const _Myt& rhs) const	{ return *(static_cast<value_ptr>(this->m_ptr)) >= *rhs; }

	/// |C^擾
	value_ptr		ptr(void) const			{ return static_cast<value_ptr>(this->m_ptr); }
	/// Xgvf폜邽߂̃\bh
	virtual void	erase(void)				{ this->liberate(); }
	/// |C^̐ݒ
	void			set(value_ptr ptr)		{ IRIS_ASSERT(!this->is_link()); this->m_ptr = ptr; }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
