//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndWrapObject.h
 * @brief		IuWFNgbsONX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndWrapObject_H_
#define INCG_IRIS_FndWrapObject_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

/// bsONXx[X
template<typename TN_>
class CWrapObject : public IIrisObject
{
	typedef CWrapObject<TN_>	_Myt;
public:
	typedef TN_			value_type;
	typedef TN_			*value_ptr;
	typedef TN_			&value_ref;
protected:
	value_type	m_object;	//!< bsOΏۃIuWFNg
public:
	/// RXgN^
	CWrapObject(void) : m_object(nullptr) {}
	/// RXgN^
	explicit CWrapObject(const value_type object) : m_object(object) {}
	/// RXgN^
	explicit CWrapObject(const _Myt& object) : m_object(object.m_object) {}

public:
	// IuWFNgւ̃ANZX
	/**
	 * @name	operator
	 * @{
	*/
	operator			value_type			(void)			{ return m_object; }
	operator			const value_type	(void)	const	{ return m_object; }
	value_type			operator () (void)			{ return m_object; }
	const value_type	operator () (void)	const	{ return m_object; }
	value_type			operator -> (void)			{ return m_object; }
	const value_type	operator -> (void)	const	{ return m_object; }
	value_ptr			operator &	(void)			{ return ptr(); }
	const value_ptr		operator &	(void)	const	{ return ptr(); }
	value_ref			operator *	(void)			{ return ref(); }
	const value_type&	operator *	(void)	const	{ return ref(); }
	_Myt&				operator =	(value_type obj)			{ m_object = obj; return *this; }
	_Myt&				operator =	(const _Myt& obj)			{ m_object = obj.m_object; return *this; }
#if	defined(_IRIS_HAS_NULLPTR_T)
	_Myt&				operator =	(const nullptr_t& null)		{ m_object = null; return *this; }
#endif
	/**
	 * @}
	*/

public:
	value_ptr			ptr(void)				{ return &m_object; }
	value_ref			ref(void)				{ return m_object; }
	const value_ptr		ptr(void)		const	{ return &m_object; }
	const value_type&	ref(void)		const	{ return m_object; }
	bool				is_valid(void)	const	{ return m_object != nullptr; }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
