//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndInteractiveList.h
 * @brief		oXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndInteractiveList_H_
#define INCG_IRIS_FndInteractiveList_H_

//======================================================================
// include
#include "../../../iris_object.h"
#include "../../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	oXgNX
 * @tparam _TC = i[^
*/
template<class _TC>
class CInteractiveList : private INonCopyable< CInteractiveList<_TC> >
{
	typedef CInteractiveList<_TC>	_Myt;
public:
	typedef _TC		value_type;
	typedef _TC		*value_ptr;
	typedef _TC		&value_ref;
protected:
	value_ptr	m_pre;	//!< ON
	value_ptr	m_next;	//!< N
public:
	/// RXgN^
	CInteractiveList(void) : m_pre(nullptr), m_next(nullptr)	{}
	/// fXgN^
	~CInteractiveList(void)
	{
		unlink();
	}
public:
	/// N
	virtual void	unlink(void)
	{
		value_ptr pre = m_pre;
		value_ptr next = m_next;
		if( pre != nullptr )	pre->m_next = next;
		if( next != nullptr )	next->m_pre = pre;
		m_pre = m_next = nullptr;
	}
	/// Oɑ}
	virtual void	insert(value_ptr const ptr)
	{
		IRIS_ASSERT( ptr != nullptr );
		if( m_pre != nullptr )
			m_pre->m_next = ptr;
		ptr->m_next = static_cast<value_ptr>(this);
		m_pre = ptr;
	}
	/// ɑ}
	virtual void	insert_back(value_ptr const ptr)
	{
		IRIS_ASSERT( ptr != nullptr );
		if( m_next != nullptr )
			m_next->m_pre = ptr;
		ptr->m_pre = static_cast<value_ptr>(this);
		m_next = ptr;
	}
	/// NĂ邩ǂ
	bool	is_link(void)
	{
		return (m_pre != nullptr || m_next != nullptr);
	}
};

}	// end of namespace iris
}	// end of namespace iris

#endif
