//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndLinearList.h
 * @brief		PXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndLinearList_H_
#define INCG_IRIS_FndLinearList_H_

//======================================================================
// include
#include "../../../iris_object.h"
#include "../../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	PXgm[hNX
 * @tparam TC_ = i[^
*/
template<class TC_>
class CLinearListNode : private INonCopyable< CLinearListNode<TC_> >
{
	typedef CLinearListNode<_TC>	_Myt;
public:
	typedef TC_		value_type;
	typedef TC_		*value_ptr;
	typedef TC_		&value_ref;
protected:
	value_ptr	m_next;	//!< N
public:
	/// RXgN^
	CLinearListNode(void) : m_next(nullptr)	{}
	/// fXgN^
	~CLinearList(void) {}
public:

};

/**
 * @brief	PXgNX
 * @tparam TC_ = i[^
*/
template<class TC_>
class CLinearList : private INonCopyable< CLinearList<TC_> >
{
	typedef CLinearList<_TC>	_Myt;
public:
	typedef TC_		node_type;
	typedef TC_		*node_ptr;
protected:
	node_ptr	m_top;	//!< 擪N
public:
	/// RXgN^
	CLinearList(void) : m_top(nullptr)	{}
	/// fXgN^
	~CLinearList(void) {}

public:
	/**
	 * @brief	ǉ
	*/
	void	push_back(node_ptr* p)
	{
		if( m_top == nullptr ) m_top = p;
		else
		{
			node_ptr curr = m_top;
			while(curr->m_next != nullptr)
			{
				curr = curr->m_next;
			}
			curr->m_next = p;
		}
	}

	/**
	 * @brief	폜
	*/
	void	erase(node_ptr* p)
	{
		if( p == nullptr ) return;
		if( m_top == p ) m_top = m_top->m_next;
		else
		{
			node_ptr curr = m_top->m_next;
			node_ptr prev = m_top;
			while(curr != p && curr != nullptr)
			{
				prev = curr;
				curr = prev->m_next;
			}
			if( curr != nullptr )
			{
				prev->m_next = curr->m_next;
			}
		}
	}
};


}	// end of namespace iris
}	// end of namespace iris

#endif
