//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndRegexOp.h
 * @brief		regex Iy[^ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndRegexOp_H_
#define INCG_IRIS_FndRegexOp_H_

//======================================================================
// include
#include "FndOperator.h"
#include "../../c++0x/cpp0x_regex.hpp"

#if	defined(_IRIS_SUPPORT_REGEX)

namespace iris {
namespace fnd
{

//======================================================================
// declare
template<cpp0x::tr1::regex_constants::match_flag_type _MATCH_FLAGS>
class CRegexMatchOp;		// regex_match operator
template<cpp0x::tr1::regex_constants::match_flag_type _MATCH_FLAGS>
class CRegexSearchOp;		// regex_search operator

//======================================================================
// class

//! regex_match operator IuWFNg
template<cpp0x::tr1::regex_constants::match_flag_type _MATCH_FLAGS=cpp0x::tr1::regex_constants::match_default>
class CRegexMatchOp : public COperatorObject
{
	typedef CRegexMatchOp<_MATCH_FLAGS>		_Myt;
public:
	template<typename _TN1, typename _TN2>
	inline s32	operator ()(const _TN1& lhs, const _TN2& rhs)	const
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		if( !cpp0x::tr1::regex_match(lhs, rhs, _MATCH_FLAGS) )
			return 0;
		return 1;
	}

private:
	// TODO : Ή
	template<typename _TN>struct _append_impl	{ typedef CFalseOp	other; };
	template<typename _TN>struct _erase_impl	{ typedef CFalseOp	other; };
	template<cpp0x::tr1::regex_constants::match_flag_type _TN>struct _opposite_impl	{ typedef CFalseOp	opposite; };

public:
	// operatorɕʂoperatort
	template<typename _TN>struct append		{ typedef typename _append_impl<_TN>::other	other; };
	// operatorperator폜
	template<typename _TN>struct erase		{ typedef typename _erase_impl<_TN>::other	other; };
	// ΂̐operator
	typedef typename _opposite_impl<_MATCH_FLAGS>::opposite		opposite;
};

//! regex_search operator IuWFNg
template<cpp0x::tr1::regex_constants::match_flag_type _MATCH_FLAGS=cpp0x::tr1::regex_constants::match_default>
class CRegexSearchOp : public COperatorObject
{
	typedef CRegexSearchOp<_MATCH_FLAGS>		_Myt;
public:
	template<typename _TN1, typename _TN2>
	inline s32	operator ()(const _TN1& lhs, const _TN2& rhs)	const
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		if( !cpp0x::tr1::regex_search(lhs, rhs, _MATCH_FLAGS) )
			return 0;
		return 1;
	}

private:
	// TODO : Ή
	template<typename _TN>struct _append_impl	{ typedef CFalseOp	other; };
	template<typename _TN>struct _erase_impl	{ typedef CFalseOp	other; };
	template<cpp0x::tr1::regex_constants::match_flag_type _TN>struct _opposite_impl	{ typedef CFalseOp	opposite; };

public:
	// operatorɕʂoperatort
	template<typename _TN>struct append		{ typedef typename _append_impl<_TN>::other	other; };
	// operatorperator폜
	template<typename _TN>struct erase		{ typedef typename _erase_impl<_TN>::other	other; };
	// ΂̐operator
	typedef typename _opposite_impl<_MATCH_FLAGS>::opposite		opposite;
};

}	// end of namespace fnd
}	// end of namespace iris

#endif

#endif
