//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndStringOp.h
 * @brief		r Iy[^ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndStringOp_H_
#define INCG_IRIS_FndStringOp_H_

//======================================================================
// include
#include "FndOperator.h"

namespace iris {
namespace fnd
{

// rIy[^
/// strstr Iy[^
class CStrstrOp : public COperatorObject
{
public:
	inline bool operator ()(LPCSTR  lhs, LPCSTR rhs)	const	{ return strstr(lhs, rhs) != nullptr; }
	inline bool operator ()(LPCWSTR lhs, LPCWSTR rhs)	const	{ return wcsstr(lhs, rhs) != nullptr; }
};

/// strcmp Iy[^
class CStrcmpOp : public COperatorObject
{
public:
	inline bool operator ()(LPCSTR  lhs, LPCSTR rhs)	const	{ return strcmp(lhs, rhs) == 0; }
	inline bool operator ()(LPCWSTR lhs, LPCWSTR rhs)	const	{ return wcscmp(lhs, rhs) == 0; }
};

/// strcmp Iy[^
class CStrncmpOp : public COperatorObject
{
private:
	size_t	m_n;
public:
	CStrncmpOp(size_t n) : m_n(n) {}
public:
	inline bool operator ()(LPCSTR  lhs, LPCSTR rhs)	const	{ return strncmp(lhs, rhs, m_n) == 0; }
	inline bool operator ()(LPCWSTR lhs, LPCWSTR rhs)	const	{ return wcsncmp(lhs, rhs, m_n) == 0; }
};

/// stricmp Iy[^
class CStricmpOp : public COperatorObject
{
public:
	inline bool operator ()(LPCSTR  lhs, LPCSTR rhs)	const	{ return _stricmp(lhs, rhs) == 0; }
	inline bool operator ()(LPCWSTR lhs, LPCWSTR rhs)	const	{ return _wcsicmp(lhs, rhs) == 0; }
};


}	// end of namespace fnd
}	// end of namespace iris

#endif
