//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndVaugeOperator.h
 * @brief		B operator IuWFNgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndVaugeOperator_H_
#define INCG_IRIS_FndVaugeOperator_H_

//======================================================================
// include
#include "FndOperator.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
class CVaugeOp;			// ɞB
class CVaugeFalseOp;	// ɋU
class CVaugeTrueOp;		// ɐ^
class CVaugeEqualOp;	// ==
class CVaugeLessOp;		// <
class CVaugeLEqualOp;	// <=
class CVaugeGreaterOp;	// >
class CVaugeGEqualOp;	// >=
class CVaugeNotEqualOp;	// !=

//======================================================================
// class
//! false operator IuWFNg
class CVaugeFalseOp : public COperatorObject
{
public:
	template<typename _TN>
	inline IrisVaugeBool	operator ()(const _TN& lhs, const _TN& rhs)	const
	{
		IRIS_UNUSED_VARIABLE(lhs);
		IRIS_UNUSED_VARIABLE(rhs);
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return IrisVaugeBool::VB_FALSE;
	}

public:
	// operatorɕʂoperatort
	template<typename _TN>struct append		{ typedef _TN			type; };
	// operatorperator폜
	template<typename _TN>struct erase		{ typedef CVaugeFalseOp	type; };
	// ΂̐operator
	typedef CVaugeTrueOp		opposite;
};

//! true operator IuWFNg
class CVaugeTrueOp : public COperatorObject
{
public:
	template<typename _TN>
	inline IrisVaugeBool	operator ()(const _TN& lhs, const _TN& rhs)	const
	{
		IRIS_UNUSED_VARIABLE(lhs);
		IRIS_UNUSED_VARIABLE(rhs);
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return IrisVaugeBool::VB_TRUE;
	}

private:
	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl		{ typedef typename _TN::opposite	type; };
	template<class _TC>struct erase_impl<_TC, _TC>			{ typedef CVaugeFalseOp				type; };

public:
	// operatorɕʂoperatort
	template<typename _TN>struct append		{ typedef _TN		type; };
	// operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CVaugeTrueOp, _TN>::type	type;
	};
	// ΂̐operator
	typedef CVaugeFalseOp	opposite;
};

//! == operator IuWFNg
class CVaugeEqualOp : public COperatorObject
{
public:
	template<typename _TN>
	inline IrisVaugeBool	operator ()(const _TN& lhs, const _TN& rhs)	const
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return lhs == rhs ? IrisVaugeBool::VB_TRUE : IrisVaugeBool::VB_FALSE;
	}

private:
	// operatorɕʂoperatort
	template<class _TC, typename _TN>struct append_impl				{ typedef _TN		type; };
	template<class _TC>struct append_impl<_TC, CVaugeLessOp>		{ typedef CVaugeLEqualOp	type; };
	template<class _TC>struct append_impl<_TC, CVaugeGreaterOp>		{ typedef CVaugeGEqualOp	type; };
	template<class _TC>struct append_impl<_TC, CVaugeNotEqualOp>	{ typedef CVaugeTrueOp	type; };

	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl			{ typedef _TC			type; };
	template<class _TC>struct erase_impl<_TC, _TC>				{ typedef CVaugeFalseOp	type; };
	template<class _TC>struct erase_impl<_TC, CVaugeGEqualOp>	{ typedef CVaugeFalseOp	type; };
	template<class _TC>struct erase_impl<_TC, CVaugeLEqualOp>	{ typedef CVaugeFalseOp	type; };
	template<class _TC>struct erase_impl<_TC, CVaugeTrueOp>		{ typedef CVaugeFalseOp	type; };

public:
	// operatorɕʂoperatort
	template<typename _TN>struct append {
		typedef typename append_impl<CVaugeEqualOp, _TN>::type	type;
	};
	// operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CVaugeEqualOp, _TN>::type	type;
	};
	// ΂̐operator
	typedef CVaugeNotEqualOp	opposite;
};

//! < operator IuWFNg
class CVaugeLessOp : public COperatorObject
{
public:
	template<typename _TN>
	inline IrisVaugeBool	operator ()(const _TN& lhs, const _TN& rhs)	const
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return lhs < rhs ? IrisVaugeBool::VB_TRUE : (lhs > rhs ? IrisVaugeBool::VB_FALSE : IrisVaugeBool::VB_VAUGE);
	}

private:
	// operatorɕʂoperatort
	template<class _TC, typename _TN>struct append_impl				{ typedef _TN				type; };
	template<class _TC>struct append_impl<_TC, CVaugeEqualOp>		{ typedef CVaugeLEqualOp	type; };
	template<class _TC>struct append_impl<_TC, CVaugeGreaterOp>		{ typedef CVaugeNotEqualOp	type; };
	template<class _TC>struct append_impl<_TC, CVaugeGEqualOp>		{ typedef CVaugeTrueOp		type; };
	template<class _TC>struct append_impl<_TC, CVaugeNotEqualOp>	{ typedef _TC				type; };

	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl			{ typedef _TC				type; };
	template<class _TC>struct erase_impl<_TC, _TC>				{ typedef CVaugeFalseOp		type; };
	template<class _TC>struct erase_impl<_TC, CVaugeLEqualOp>	{ typedef CVaugeFalseOp		type; };
	template<class _TC>struct erase_impl<_TC, CVaugeNotEqualOp>	{ typedef typename append_impl<_TC, CVaugeEqualOp>::type	type; };
	template<class _TC>struct erase_impl<_TC, CVaugeTrueOp>		{ typedef CVaugeFalseOp		type; };

public:
	// operatorɕʂoperatort
	template<typename _TN>struct append {
		typedef typename append_impl<CVaugeLessOp, _TN>::type	type;
	};
	// operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CVaugeLessOp, _TN>::type	type;
	};
	// ΂̐operator
	typedef CVaugeGEqualOp	opposite;
};

//! <= operator IuWFNg
class CVaugeLEqualOp : public COperatorObject
{
public:
	template<typename _TN>
	inline IrisVaugeBool	operator ()(const _TN& lhs, const _TN& rhs)	const
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return lhs <= rhs ? IrisVaugeBool::VB_TRUE : IrisVaugeBool::VB_FALSE;
	}

private:
	// operatorɕʂoperatort
	template<class _TC, typename _TN>struct append_impl				{ typedef _TN				type; };
	template<class _TC>struct append_impl<_TC, CVaugeEqualOp>		{ typedef CVaugeLEqualOp	type; };
	template<class _TC>struct append_impl<_TC, CVaugeLessOp>		{ typedef CVaugeLEqualOp	type; };
	template<class _TC>struct append_impl<_TC, CVaugeGreaterOp>		{ typedef CVaugeTrueOp		type; };
	template<class _TC>struct append_impl<_TC, CVaugeGEqualOp>		{ typedef CVaugeTrueOp		type; };
	template<class _TC>struct append_impl<_TC, CVaugeNotEqualOp>	{ typedef CVaugeLessOp		type; };

	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl			{ typedef _TC				type; };
	template<class _TC>struct erase_impl<_TC, _TC>				{ typedef CVaugeFalseOp		type; };
	template<class _TC>struct erase_impl<_TC, CVaugeEqualOp>	{ typedef CVaugeLessOp		type; };
	template<class _TC>struct erase_impl<_TC, CVaugeLessOp>		{ typedef CVaugeEqualOp		type; };
	template<class _TC>struct erase_impl<_TC, CVaugeTrueOp>		{ typedef CVaugeFalseOp		type; };

public:
	// operatorɕʂoperatort
	template<typename _TN>struct append {
		typedef typename append_impl<CVaugeLEqualOp, _TN>::type	type;
	};
	// operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CVaugeLEqualOp, _TN>::type		type;
	};
	// ΂̐operator
	typedef CVaugeGreaterOp	opposite;
};

//! > operator IuWFNg
class CVaugeGreaterOp : public COperatorObject
{
public:
	template<typename _TN>
	inline IrisVaugeBool	operator ()(const _TN& lhs, const _TN& rhs)	const
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return lhs > rhs ? IrisVaugeBool::VB_TRUE : (lhs < rhs ? IrisVaugeBool::VB_FALSE : IrisVaugeBool::VB_VAUGE);
	}

private:
	// operatorɕʂoperatort
	template<class _TC, typename _TN>struct append_impl				{ typedef _TN				type; };
	template<class _TC>struct append_impl<_TC, CVaugeEqualOp>		{ typedef CVaugeGEqualOp	type; };
	template<class _TC>struct append_impl<_TC, CVaugeLessOp>		{ typedef CVaugeNotEqualOp	type; };
	template<class _TC>struct append_impl<_TC, CVaugeLEqualOp>		{ typedef CVaugeTrueOp		type; };
	template<class _TC>struct append_impl<_TC, CVaugeNotEqualOp>	{ typedef CVaugeGreaterOp	type; };

	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl			{ typedef _TC				type; };
	template<class _TC>struct erase_impl<_TC, _TC>				{ typedef CVaugeFalseOp		type; };
	template<class _TC>struct erase_impl<_TC, CVaugeGEqualOp>	{ typedef CVaugeFalseOp		type; };
	template<class _TC>struct erase_impl<_TC, CVaugeNotEqualOp>	{ typedef typename append_impl<_TC, CVaugeEqualOp>::type	type; };
	template<class _TC>struct erase_impl<_TC, CVaugeTrueOp>		{ typedef CVaugeFalseOp		type; };

public:
	// operatorɕʂoperatort
	template<typename _TN>struct append {
		typedef typename append_impl<CVaugeGreaterOp, _TN>::type	type;
	};
	// operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CVaugeGreaterOp, _TN>::type	type;
	};
	// ΂̐operator
	typedef CVaugeLEqualOp	opposite;
};

//! >= operator IuWFNg
class CVaugeGEqualOp : public COperatorObject
{
public:
	template<typename _TN>
	inline IrisVaugeBool	operator ()(const _TN& lhs, const _TN& rhs)	const
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return lhs >= rhs ? IrisVaugeBool::VB_TRUE : IrisVaugeBool::VB_FALSE;
	}

private:
	// operatorɕʂoperatort
	template<class _TC, typename _TN>struct append_impl				{ typedef _TN				type; };
	template<class _TC>struct append_impl<_TC, CVaugeEqualOp>		{ typedef CVaugeGEqualOp	type; };
	template<class _TC>struct append_impl<_TC, CVaugeLessOp>		{ typedef CVaugeTrueOp		type; };
	template<class _TC>struct append_impl<_TC, CVaugeLEqualOp>		{ typedef CVaugeTrueOp		type; };
	template<class _TC>struct append_impl<_TC, CVaugeGreaterOp>		{ typedef CVaugeGEqualOp	type; };
	template<class _TC>struct append_impl<_TC, CVaugeNotEqualOp>	{ typedef CVaugeGreaterOp	type; };

	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl			{ typedef _TC				type; };
	template<class _TC>struct erase_impl<_TC, _TC>				{ typedef CVaugeFalseOp		type; };
	template<class _TC>struct erase_impl<_TC, CVaugeEqualOp>	{ typedef CVaugeGreaterOp	type; };
	template<class _TC>struct erase_impl<_TC, CVaugeGreaterOp>	{ typedef CVaugeEqualOp		type; };
	template<class _TC>struct erase_impl<_TC, CVaugeTrueOp>		{ typedef CVaugeFalseOp		type; };

public:
	// operatorɕʂoperatort
	template<typename _TN>struct append {
		typedef typename append_impl<CVaugeGEqualOp, _TN>::type	type;
	};
	// operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CVaugeGEqualOp, _TN>::type		type;
	};
	// ΂̐operator
	typedef CVaugeLessOp	opposite;
};

//! != operator IuWFNg
class CVaugeNotEqualOp : public COperatorObject
{
public:
	template<typename _TN>
	inline IrisVaugeBool	operator ()(const _TN& lhs, const _TN& rhs)	const
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return lhs != rhs ? IrisVaugeBool::VB_TRUE : IrisVaugeBool::VB_FALSE;
	}

private:
	// operatorɕʂoperatort
	template<class _TC, typename _TN>struct append_impl			{ typedef _TN				type; };
	template<class _TC>struct append_impl<_TC, CVaugeEqualOp>	{ typedef CVaugeTrueOp		type; };
	template<class _TC>struct append_impl<_TC, CVaugeGEqualOp>	{ typedef CVaugeGreaterOp	type; };
	template<class _TC>struct append_impl<_TC, CVaugeLEqualOp>	{ typedef CVaugeLessOp		type; };

	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl			{ typedef _TC				type; };
	template<class _TC>struct erase_impl<_TC, _TC>				{ typedef CVaugeFalseOp		type; };
	template<class _TC>struct erase_impl<_TC, CVaugeTrueOp>		{ typedef CVaugeFalseOp		type; };

public:
	// operatorɕʂoperatort
	template<typename _TN>struct append {
		typedef typename append_impl<CVaugeNotEqualOp, _TN>::type	type;
	};
	// operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CVaugeNotEqualOp, _TN>::type	type;
	};
	// ΂̐operator
	typedef CVaugeEqualOp	opposite;
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
