//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndRefCntPtr.h
 * @brief		Reference Pointer  NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndRefCntPtr_H_
#define INCG_IRIS_FndRefCntPtr_H_

//======================================================================
// include
#include "../../../iris_object.h"
#include "../../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	QƃJEg|C^NX
*/
template< typename TN_>
class CRefCntPtr : public IIrisObject
{
	typedef CRefCntPtr<TN_>	_Myt;
public:
	typedef TN_			value_type;
	typedef value_type	*value_ptr;

private:
	value_ptr	m_ptr;	//!< |C^

public:
	/**
	 * RXgN^
	 * @param [in]	ptr = |C^
	*/
	CRefCntPtr(value_ptr ptr = nullptr)
		: m_ptr(nullptr)
	{
		if( ptr != nullptr )
		{
			ptr->AddRef();
			m_ptr = ptr;
		}
	}

	/**
	 * RXgN^
	*/
	CRefCntPtr(const _Myt& rhs)
		: m_ptr(nullptr)
	{
		value_ptr ptr = rhs.m_ptr;
		if( ptr != nullptr )
		{
			ptr->AddRef();
			m_ptr = ptr;
		}
	}
	/**
	 * fXgN^
	*/
	~CRefCntPtr(void)
	{
		value_ptr ptr = m_ptr;
		m_ptr = nullptr;
		m_ptr->Release();
	}

public:
	/**
	 * 
	*/
	const _Myt&	operator = ( const _Myt& ref )
	{
		if( m_ptr != nullptr ) m_ptr->Release();
		value_ptr ptr = ref.m_ptr;
		if( ptr != nullptr ) ptr->AddRef();
		m_ptr = ptr;
		return *this;
	}

					operator value_ptr	(void)		const { return m_ptr; }
	value_ptr		operator -> ( void )			const { return m_ptr; }
	bool			operator == (const _Myt& rhs)	const { return m_ptr == rhs.m_ptr; }
	bool			operator != (const _Myt& rhs)	const { return m_ptr != rhs.m_ptr; }

	bool			is_valid( void )	const { return m_ptr != nullptr; }
	bool			is_invalid( void )	const { return m_ptr == nullptr; }
	value_ptr		ptr( void )			const { return m_ptr; }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
