//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndRefPtr.h
 * @brief		Reference Pointer NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndRefPtr_H_
#define INCG_IRIS_FndRefPtr_H_

//======================================================================
// include
#include "../FndLiberator.h"
#include "../FndAllocator.h"
#include "../../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	QƃJEg|C^ǗNX
 * @details	(@ref section_autoexp_CRefPtr "autoexp")
 *
 * @note	:̃NXɂĊǗĂ|C^́AQƐ悪͉邱Ƃ͂ȂB
 *			܂AQƐ悪ȂƎIɉB
 *			̋ template  liberator ɂĎRɌ߂邱ƂłB
 *
 * @note	:̃NX̊OŁA|C^ꂽꍇ́AǗĂ|C^
 *			^uO|C^ƂȂē삪sɂȂ邽߁Aptr() Ń|C^擾Ă
 *			͂ȂłB
 *
 * @note	:܂Al̗RɂAꏊw|C^ CRefPtr  ʏ̃|C^ƂŁA
 *			ʂ̊Ǘ@ŊǗ悤Ȏg͂ȂłB
 *			CRefPtr ŊǗĂ|C^ CRefPtr ŊǗ悤ɂĂB
 *
 * @tparam	_TN			= Ώی^
 * @tparam	_Liberator	= NX^
 * @tparam	_Allocator	= AP[^^Cv
*/
template< typename _TN, typename _Liberator = CLiberatorObject<_TN>, typename _Allocator = CNewAllocator<_TN> >
class CRefPtr : public IIrisObject
{
	typedef CRefPtr<_TN, _Liberator, _Allocator>	_Myt;
public:
	typedef _TN			value_type;
	typedef value_type	*value_ptr;

private:
	/// QƃIuWFNg
	class CRefObj : public _Liberator, public CAllocatorInstance<typename _Allocator::template rebind<CRefObj>::type>
	{
	public:
		typedef typename _Allocator::template rebind<CRefObj>::type allocator_type;
		typedef _TN		*value_ptr;
	public:
		s32		m_refcnt;	//!< QƃJE^
	public:
		CRefObj(void) : m_refcnt(0) {}
		CRefObj(value_ptr ptr) : _Liberator(ptr), m_refcnt(1) {}
		~CRefObj(void)	{}
	public:
		value_ptr ptr(void)					{ return static_cast<value_ptr>(this->m_ptr); }
		CRefObj& operator = (value_ptr p)	{ this->m_ptr = p; return *this; }

	public:
		void	inc_ref(void)	{ ++m_refcnt; }
		void	dec_ref(void)
		{
			if( this->m_ptr != nullptr )
			{
				--m_refcnt;
				if( m_refcnt <= 0 ) this->liberate();
			}
		}
	};

private:
	CRefObj*	m_ref;	//!< t@X

private:
	explicit CRefPtr(CRefObj* obj) { m_ref = obj; }
public:
	/**
	 * RXgN^
	 * @param [in]	ptr = |C^
	*/
	CRefPtr(value_ptr ptr = nullptr)
	{
		if( ptr != nullptr )
		{
			m_ref = static_cast<CRefObj*>(CRefObj::allocator().alloc());
			IRIS_ASSERT(m_ref != nullptr);
			m_ref->operator=(ptr);
			m_ref->m_refcnt = 1;
		}
		else
		{
			 m_ref = null().m_ref;
		}
	}

	/**
	 * RXgN^
	 * @param [in]	ref = t@X|C^
	*/
	CRefPtr(const _Myt& ref)
	{
		m_ref = ref.m_ref;
		m_ref->inc_ref();
	}
	/**
	 * fXgN^
	*/
	~CRefPtr(void)
	{
		m_ref->dec_ref();
		if( m_ref->m_refcnt <= 0 )
			CRefObj::allocator().dealloc(m_ref);
	}

public:
	/**
	 * 
	*/
	const _Myt&	operator = ( const _Myt& ref )
	{
		ref.m_ref->inc_ref();
		m_ref->dec_ref();
		if( m_ref->m_refcnt <= 0 ) {
			CRefObj::allocator().dealloc(m_ref);
		}
		m_ref = ref.m_ref;
		return *this;
	}

					operator value_ptr	(void)		const { return m_ref->ptr(); }
	value_ptr		operator -> ( void )			const { return m_ref->ptr(); }
	bool			operator == (const _Myt& rhs)	const { return m_ref->ptr() == rhs.m_ref->ptr(); }
	bool			operator != (const _Myt& rhs)	const { return m_ref->ptr() != rhs.m_ref->ptr(); }

	bool			is_valid( void )	const { return m_ref->ptr() != nullptr; }
	bool			is_invalid( void )	const { return m_ref->ptr() == nullptr; }
	value_ptr		ptr( void )			const { return m_ref->ptr(); }

public:
	static const _Myt& null( void )
	{
		static CRefObj obj(nullptr);
		static _Myt null_pointer(&obj);
		return null_pointer;
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif

/**
 * @addtogroup	autoexp
 * @{
 * @addtogroup	Visualizer
 * @section		section_autoexp_CRefPtr		; iris::fnd::CRefPtr
 * @code
;------------------------------------------------------------------------------
; iris::fnd::CRefPtr
;------------------------------------------------------------------------------
iris::fnd::CRefPtr<*,*,*> {
	children
	(
		#(
			[actual members]: [$e,!],
			ptr  : ($T1*)($e.m_ref->m_ptr),
			refcnt : $e.m_ref->m_refcnt
		)
	)
	preview
	(
		#if ($e.m_ref == 0) (
			"?"
		) #else (
			#(
				"[", $e.m_ref->m_ptr, "] (", $e.m_ref->m_refcnt, ")"
			)
		)
	)
}
 * @endcode
 * @}
*/
