//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndBubbleSort.h
 * @brief		ou\[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndBubbleSort_H_
#define INCG_IRIS_FndBubbleSort_H_

//======================================================================
// include
#include "../FndOperators.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	ou\[g
 * @note	ňvZ	O(n2)
 *			ŗǌvZ	O(n)
 *			όvZ	O(n2)
 * @note	\[g
*/
class CBubbleSort : public IIrisObject
{
public:
	/**
	 * @brief ou\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	num		= \[gz̗vf
	 * @param [in]	func	= r֐
	*/
	template<typename TN, typename Func>
	static void	Sort(TN& elem, s32 num, const Func& func)
	{
		Sort(elem, 0, num, func);
	}

public:
	/**
	 * @brief ou\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	begin	= \[gJnCfbNX
	 * @param [in]	end		= \[gI[CfbNX
	 * @param [in]	func	= r֐
	*/
	template<typename TN, typename Func>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func& func)
	{
		s32 num = end - begin;
		for( s32 i=0, n=num-1; i < n; ++i )
		{
			for( s32 j=0; j < n-i; ++j )
			{
				s32 k=j+begin;
				if( !func(elem[k], elem[k+1]) )
				{
					swap(elem[k], elem[k+1]);
				}
			}
		}
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
