//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndHeapSort.h
 * @brief		q[v\[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndHeapSort_H_
#define INCG_IRIS_FndHeapSort_H_

//======================================================================
// include
#include "../FndOperators.h"
#include "../../../c++0x/cpp0x_type_traits.hpp"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	q[v\[g
 * @note	ňvZ	
 *			ŗǌvZ	
 *			όvZ	(n log n)
 * @note	s\[g
*/
class CHeapSort : public IIrisObject
{
public:
	/**
	 * @brief q[v\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	num		= \[gz̗vf
	 * @param [in]	func	= r֐
	*/
	template<typename TN, typename Func>
	static void	Sort(TN& elem, s32 num, const Func& func)
	{
		Sort(elem, 0, num, func);
	}

public:
	/**
	 * @brief q[v\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	begin	= 擪index
	 * @param [in]	end		= I[index
	 * @param [in]	func	= r֐
	*/
	template<typename TN, typename Func>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func& func)
	{
		Sort<cpp0x::array_traits<TN>::element>(elem, begin, end, func);
	}
	template<typename ELEM, typename TN, typename Func>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func& func)
	{
		// q[v\̍\z
		MakeHeapTree<ELEM>(elem, begin, end, func);

		// \[g
		for( s32 i=end-1; i > begin; --i )
		{
			swap(elem[begin], elem[i]);
			// č\z
			MakeHeapTree<ELEM>(elem, begin, i, func);
		}
	}

private:
	template<typename ELEM, typename TN, typename Func>
	static void	MakeHeapTree(TN& elem, s32 begin, s32 end, const Func& func)
	{
		s32 k = (end - begin - 1) / 2;
		s32 a = k;
		for( s32 a=k; a >= 0; )
		{
			s32 j = 2 * k + 1 + begin;
			s32 kk = k + begin;
			if( j == kk || j >= end )
			{
				// qm[hȂ
				--a;
				k = a;
			}
			else
			{
				s32 jj = j;
				if( j+1 < end )
				{
					// j+1 ɂm[hΔr
					if( func(elem[j], elem[j+1]) )
					{
						jj = j+1;
					}
				}
				if( func(elem[jj], elem[kk]) )
				{
					--a;
					k = a;
				}
				else
				{
					swap(elem[kk], elem[jj]);
					k = jj;
				}
			}
		}
	}

};

}	// end of namespace fnd
}	// end of namespace iris

#endif
