//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndIntroSort.h
 * @brief		Cg\[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndIntroSort_H_
#define INCG_IRIS_FndIntroSort_H_

//======================================================================
// include
#include "FndInsertSort.h"
#include "FndHeapSort.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	Cg\[g
 * @note	ňvZ	O(n log n)
 *			ŗǌvZ	O(n log n)
 *			όvZ	O(n log n)
 * @note	s\[g
*/
class CIntroSort
{
public:
	static const s32 MINIMUM_ELEMENT		= 32;	//!< ŏvf
	static const s32 HEAPSORT_CHANGE_DEPTH	= 16;	//!< q[v\[gɐ؂ւ
public:
	/**
	 * @brief Cg\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	num		= \[gz̗vf
	 * @param [in]	func	= r֐
	*/
	template<typename TN, typename Func>
	static void	Sort(TN& elem, s32 num, const Func& func)
	{
		Sort(elem, 0, num, func);
	}

	/**
	 * @brief Cg\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	num		= \[gz̗vf
	 * @param [in]	begin	= 擪index
	 * @param [in]	end		= I[index
	 * @param [in]	func	= r֐
	*/
	template<typename TN, typename Func>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func& func)
	{
		typename Func::append<CEqualOp>::type	func2;
		Sort(elem, begin, end, func, func2);
	}

public:
	/**
	 * @brief Cg\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	begin	= 擪index
	 * @param [in]	end		= I[index
	 * @param [in]	func	= r֐
	 * @param [in]	func	= r֐
	*/
	template<typename TN, typename Func1, typename Func2>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func1& func1, const Func2& func2)
	{
		Sort<typename cpp0x::array_traits<TN>::element>(elem, begin, end, func1, func2);
	}
	template<typename ELEM, typename TN, typename Func1, typename Func2>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func1& func1, const Func2& func2)
	{
		s32 num = end - begin;
		Sort<ELEM>(elem, begin, end, func1, func2, 0, num);
	}

private:
	template<typename ELEM, typename TN, typename Func1, typename Func2>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func1& func1, const Func2& func2, s32 depth, s32 elem_count)
	{
		s32 num = end - begin;
		// ȂƂ́A}\[g
		if( num < MINIMUM_ELEMENT )
		{
			CInsertSort::Sort<ELEM>(elem, begin, end, func1);
			return;
		}

		// vf̑ΐċA񐔂𒴂Aq[v\[g
		if( elem_count < depth*depth )
		{
			CHeapSort::Sort<ELEM>(elem, begin, end, func1);
			return;
		}

		int l=begin, r=end-1;
		{
			// 3TvO̒l
			ELEM a =  elem[begin+(num>>2)];
			ELEM b =  elem[begin+(num>>1)];
			ELEM c =  elem[begin+((num*3)>>2)];
			ELEM pbt = a > b ? (a < c ? a : c) : (b < c ? b : c);

			while(1)
			{
				for( ; l < end; ++l )
					if( !func1(elem[l], pbt) ) break;
				for( ; r > begin; --r )
					if(  func2(elem[r], pbt) ) break;
				if( l >= r ) break;

				swap(elem[l++], elem[r--]);
			}
		}
		s32 half = l - begin;
		num -= half;
		Sort<ELEM>(elem, begin,   l, func1, func2, depth+1, elem_count);
		Sort<ELEM>(elem,     l, end, func1, func2, depth+1, elem_count);
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
