//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSelectionSort.h
 * @brief		I\[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndSelectionSort_H_
#define INCG_IRIS_FndSelectionSort_H_

//======================================================================
// include
#include "../FndOperators.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	I\[g
 * @note	ňvZ	O(n2)
 *			ŗǌvZ	O(n2)
 *			όvZ	O(n2)
 * @note	s\[g
*/
class CSelectionSort : public IIrisObject
{
public:
	/**
	 * @brief I\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	num		= \[gz̗vf
	 * @param [in]	func	= r֐
	*/
	template<typename TN, typename Func>
	static void	Sort(TN& elem, s32 num, const Func& func)
	{
		Sort(elem, 0, num, func);
	}

public:
	/**
	 * @brief I\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	begin	= \[gJnCfbNX
	 * @param [in]	end		= \[gI[CfbNX
	 * @param [in]	func	= r֐
	*/
	template<typename TN, typename Func>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func& func)
	{
		for( s32 i=begin; i < end-1; ++i )
		{
			s32 curr = i;
			for( s32 j=i+1; j < end; ++j )
			{
				if( func(elem[j], elem[curr]) )
				{
					curr = j;
				}
			}
			swap(elem[i], elem[curr]);
		}
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
