//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndShellSort.h
 * @brief		VF\[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndShellSort_H_
#define INCG_IRIS_FndShellSort_H_

//======================================================================
// include
#include "../FndOperators.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	VF\[g
 * @note	ňvZ	O(n log2 n)
 *			ŗǌvZ	
 *			όvZ	
 * @note	s\[g
*/
class CShellSort : public IIrisObject
{
public:
	/**
	 * @brief VF\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	num		= \[gz̗vf
	 * @param [in]	func	= r֐
	*/
	template<typename TN, typename Func>
	static void	Sort(TN& elem, s32 num, const Func& func)
	{
		Sort(elem, 0, num, func);
	}

public:
	/**
	 * @brief VF\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	begin	= \[gJnCfbNX
	 * @param [in]	end		= \[gI[CfbNX
	 * @param [in]	func	= r֐
	*/
	template<typename TN, typename Func>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func& func)
	{
		Sort<cpp0x::array_traits<TN>::element>(elem, begin, end, func);
	}
	template<typename ELEM, typename TN, typename Func>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func& func)
	{
		s32 num = end - begin;
		s32 h = num * 10 / 13;
		while(h)
		{
			for( s32 i=begin+h, j; i < end; ++i )
			{
				ELEM tmp = elem[i];
				for( j=i; j-h >= begin && !func(elem[j-h], tmp); j-=h )
				{
					elem[j] = elem[j-h];
				}
				elem[j]		= tmp;
			}
			if( h == 1 )
			{
				h = 0;
			}
			else
			{
				h = h * 10 / 13;
#if 1
				if( h == 9 || h == 10 ) h = 11;
#endif
			}
		}
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
