//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndAVLTree.h
 * @brief		AVLc[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndAVLTree_H_
#define INCG_IRIS_FndAVLTree_H_

//======================================================================
// include
#include "FndBinarySearchTree.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
class CAVLTreeNodeBase;
template<typename _TN>class CAVLTreeNode;
template<typename _TN, class _Liberator>class CAVLTreeLiberateNode;
template<class _TC>class CAVLTree;

//======================================================================
// class
/// tQ؃m[hNXx[X
class CAVLTreeNodeBase : public IBSTreeNodeBase<CAVLTreeNodeBase>
{
public:
	//! m[h̃oX
	typedef enum
	{
		EVEN	= 'E',	//!< ẼoXĂ
		LEFT	= 'L',	//!< ɌXĂ
		RIGHT	= 'R'	//!< EɌXĂ
	} BALANCE;

public:
	u8			m_Balance;	//!< 

public:
	/// RXgN^
	CAVLTreeNodeBase(void) : m_Balance(EVEN) {}

	/// 폜̏
	virtual	void		erase(void)	{}
public:
	/// nullptr m[h
	static inline node_ptr		null_node(void)			{ return nullptr; }
};

/**
 * @brief	tQ؃m[hNXx[X
 * @tparam	_TN	= Ώی^
*/
template<typename _TN>
class CAVLTreeNode : public CTemplateNode<_TN, CAVLTreeNodeBase>
{
	typedef CTemplateNode<_TN, CAVLTreeNodeBase>	_Mybase;
public:
	IRIS_PP_USING_MYTYPENAME(value_ptr, _TN*, _Mybase);
	IRIS_PP_USING_MYTYPENAME(arg_type , _TN&, _Mybase);
public:
	/// RXgN^
	CAVLTreeNode(arg_type val) : CTemplateNode<_TN, CAVLTreeNodeBase>(val) {}
	/// RXgN^
	CAVLTreeNode(void)	{}
};

/**
 * @brief	tQ؃m[hNXx[X
 * @tparam	_TN			= Ώی^
 * @tparam	_Liberator	= NX^
*/
template< typename _TN, class _Liberator=CLiberatorObject<_TN> >
class CAVLTreeLiberateNode : public CTemplateLiberateNode<_TN, CAVLTreeNodeBase, _Liberator>
{
	typedef CTemplateLiberateNode<_TN, CAVLTreeNodeBase, _Liberator>	_Mybase;
public:
	IRIS_PP_USING_MYTYPENAME(value_ptr, _TN*, _Mybase);
public:
	/// RXgN^
	CAVLTreeLiberateNode(value_ptr ptr) : CTemplateLiberateNode<_TN, CAVLTreeNodeBase, _Liberator>(ptr) {}
	/// RXgN^
	CAVLTreeLiberateNode(void)	{}
};

/**
 * @brief	tQ؃NX
 *
 * @note	em[h̍E̍̍PȓɎ߂c[\
 *			m[hNX operator == ()  operator < () Kv܂B
 *
 * @tparam	_TC	= Ώی^
*/
template<class _TC>
class CAVLTree : public IBSTree<_TC, CAVLTreeNodeBase>
{
	typedef IBSTree<_TC, CAVLTreeNodeBase>	_Mybase;
public:
	IRIS_PP_USING_MYTYPENAME(value_ptr, _TC*				, _Mybase);
	IRIS_PP_USING_MYTYPENAME(node_type, CAVLTreeNodeBase	, _Mybase);
	IRIS_PP_USING_MYTYPENAME(node_ptr , CAVLTreeNodeBase*	, _Mybase);
public:
	/// RXgN^
	CAVLTree(void) {}
public:
	/// nullptr or null_nodeǂ
	virtual bool	is_null_node(node_ptr ptr)	const	{ return (ptr == nullptr); }

protected:
	/**
	 * @brief	m[h̓ւ
	 * @return	ւ̃[gm[h
	*/
	value_ptr		swap(value_ptr n1, value_ptr n2)
	{
		u8 tmp = n1->m_Balance;
		n1->m_Balance = n2->m_Balance;
		n2->m_Balance = tmp;
		return _Mybase::swap(n1, n2);
	}

private:

	/**
	 * @brief	m[h̒ǉ
	 * @param [in]	ptr	= ǉm[h
	 * @return	ǉ̃[gm[h
	*/
	virtual value_ptr		insert_internal(value_ptr ptr)
	{
		IRIS_ASSERT( ptr != nullptr );
		ptr->m_Balance	= node_type::EVEN;
		return _Mybase::insert_internal(ptr);
	}

	/**
	 * @brief	m[h̍폜
	 * @param [in]	pos	= 폜m[h
	 * @return	폜̃[gm[h
	*/
	virtual value_ptr		erase_internal(value_ptr pos)
	{
		value_ptr	target;	// 폜^[Qbg
		value_ptr	node;	// 폜^[Qbg̈ʒuɈړm[h
		value_ptr	last;	// ړm[ĥƂƂ̐em[h
		value_ptr	swapkey = nullptr;	// 폜m[hƌm[h

		IRIS_ASSERT( pos != nullptr && this->m_root != nullptr );
		// nm[h͂TreeɂƂėLȃm[hłƑO
		target = node = pos;
		last = static_cast<value_ptr>(target->m_pParent);

#ifdef _IRIS_DEBUGTEST_ENABLE
		s32 cnt = count();
#endif
		// nullptr
		if( this->is_null_node(target->m_pLeft) )
		{
			// Enullptr
			if( this->is_null_node(target->m_pRight) )
			{
				if( !this->is_null_node(last) )
				{
					// ؂藣
					if( last->m_pLeft == target )	last->m_pLeft = nullptr;
					else							last->m_pRight = nullptr;
				}
				else
				{
					IRIS_ASSERT( target == this->m_root );
					this->m_root = nullptr;
				}
				swapkey = nullptr;
			}
			else
			{
				// nullptr
				node = static_cast<value_ptr>(node->m_pRight);
				node->m_pParent = last;
				if( !this->is_null_node(last) )
				{
					// ؂藣
					if( last->m_pLeft == target )	last->m_pLeft = node;
					else							last->m_pRight = node;
				}
				swapkey = node;
			}
		}
		else if( this->is_null_node(target->m_pRight) )
		{
			// Enullptr
			node = static_cast<value_ptr>(node->m_pLeft);
			node->m_pParent = last;
			if( !this->is_null_node(last) )
			{
				// ؂藣
				if( last->m_pLeft == target )	last->m_pLeft  = node;
				else							last->m_pRight = node;
			}
			swapkey = node;
		}
		else
		{
			// EƂɃm[h
			// ̏ꍇA폜m[hƈʒuύX̂
			// Eׂďd̃m[hƂقAoXȂ
			value_ptr next = nullptr;
			u8 balance = target->m_Balance;

			// Edꍇ
			if( balance == node_type::RIGHT )
			{
				next = static_cast<value_ptr>(node->m_pRight);
				while( !this->is_null_node(next->m_pLeft) )
				{
					node = next;
					next = static_cast<value_ptr>(next->m_pLeft);
				}
				if(node == target)
				{
					next->m_pParent = last;
					next->m_pLeft = target->m_pLeft;
					if(next->m_pLeft != nullptr) next->m_pLeft->m_pParent = next;
					if(last != nullptr)
					{
						if(last->m_pLeft == target) last->m_pLeft = next;
						else						last->m_pRight = next;
					}
					else
					{
						this->m_root = next;
						if( target->m_Balance == node_type::EVEN )
							next->m_Balance = node_type::LEFT;
						else
							next->m_Balance = node_type::EVEN;
					}
					swapkey = next;
				}
				else
				{
					swapkey = static_cast<value_ptr>(next->m_pRight);
					swap(target, next);

					node->m_pLeft = swapkey;
					if(swapkey != nullptr)	swapkey->m_pParent = node;

					if( last == nullptr )
					{
						this->m_root = next;
					}
					last = node;
				}
			}
			// dꍇ
			else
			{
				next = static_cast<value_ptr>(node->m_pLeft);
				while( !this->is_null_node(next->m_pRight) )
				{
					node = next;
					next = static_cast<value_ptr>(next->m_pRight);
				}
				if(node == target)
				{
					next->m_pParent = last;
					next->m_pRight = target->m_pRight;
					if( !this->is_null_node(next->m_pRight) ) next->m_pRight->m_pParent = next;
					if(last != nullptr)
					{
						if( last->m_pLeft == target )	last->m_pLeft = next;
						else							last->m_pRight = next;
					}
					else
					{
						this->m_root = next;
						if( target->m_Balance == node_type::EVEN )
							next->m_Balance = node_type::RIGHT;
						else
							next->m_Balance = node_type::EVEN;
					}
					swapkey = next;
				}
				else
				{
					swapkey = static_cast<value_ptr>(next->m_pLeft);
					swap(target, next);

					node->m_pRight = swapkey;
					if( swapkey != nullptr )	swapkey->m_pParent = node;

					if(last == nullptr)
					{
						this->m_root = next;
					}
					last = node;
				}
			}
		}

		// target->m_pParent  nullptr ƂƂ͑Ώۂ̓[g
		if( last == nullptr )
		{
			this->m_root = swapkey;
		}

#ifdef _IRIS_DEBUGTEST_ENABLE
		check_tree_struct(this->m_root);
		IRIS_ASSERT( (cnt-1) == count() );
#endif
		this->m_root = rotate_tree_sub(last, pos, swapkey);
		target->unlink();
		target->erase();
#ifdef _IRIS_DEBUGTEST_ENABLE
		check_tree_root();
		IRIS_ASSERT( (cnt-1) == count() );
#endif
		return this->m_root;
	}

private:

	/**
	 * @brief	c[]ăoX𐮂(m[h̒ǉ)
	 * @param [in]	node	= ǉsm[h̐e
	 * @param [in]	key		= ǉsm[h̃L[
	 * @return	]̃[gm[h
	*/
	value_ptr rotate_tree_add(value_ptr node, value_ptr key)
	{
		value_ptr add = key;
		if(this->m_root == nullptr)	return nullptr;
		// node  nullptr ̏ꍇ̓c[[ĝ݂Ȃ̂ŉsȂ
		if(node == nullptr)	return this->m_root;

		// m[he root ܂ŎJ
		do
		{
			// em[hɌXĂ
			if(node->m_Balance == node_type::LEFT)
			{
				// m[hɒǉꂽꍇ
				if(node->m_pLeft == add)
				{
					// ǉꂽق̎qm[hɌXĂꍇ͉E 1 ]
					if(node->m_pLeft->m_Balance == node_type::LEFT)
					{
						value_ptr p = static_cast<value_ptr>(node->m_pLeft);
						this->m_root = this->rotate_right1(p);
						p->m_Balance = node_type::EVEN;
						p->m_pRight->m_Balance = node_type::EVEN;
					}
					// ǉꂽق̎qm[hEɌXĂꍇ͉E 2 ]
					else if(node->m_pLeft->m_Balance == node_type::RIGHT)
					{
						value_ptr p = static_cast<value_ptr>(node->m_pLeft->m_pRight);
						this->m_root = this->rotate_right2(p);
						if(p->m_Balance == node_type::LEFT)
						{
							p->m_pLeft->m_Balance = node_type::EVEN;
							p->m_pRight->m_Balance = node_type::RIGHT;
						}
						else if(p->m_Balance == node_type::RIGHT)
						{
							p->m_pLeft->m_Balance = node_type::LEFT;
							p->m_pRight->m_Balance = node_type::EVEN;
						}
						else
						{
							p->m_pLeft->m_Balance = node_type::EVEN;
							p->m_pRight->m_Balance = node_type::EVEN;
						}
						p->m_Balance = node_type::EVEN;
					}
					break;
				}
				// m[hEɒǉꂽꍇ
				else
				{
					node->m_Balance = node_type::EVEN;
					break;
				}
			}
			// em[hEɌXĂ
			else if(node->m_Balance == node_type::RIGHT)
			{
				// m[hɒǉꂽꍇ
				if(node->m_pLeft == add)
				{
					node->m_Balance = node_type::EVEN;
					break;
				}
				// m[hEɒǉꂽꍇ
				else
				{
					// ǉꂽق̎qm[hEɌXĂꍇ͍ 1 ]
					if(node->m_pRight->m_Balance == node_type::RIGHT)
					{
						value_ptr p = static_cast<value_ptr>(node->m_pRight);
						value_ptr l = node;
						this->m_root = this->rotate_left1(p);
						p->m_Balance = node_type::EVEN;
						l->m_Balance = node_type::EVEN;
					}
					// ǉꂽق̎qm[hɌXĂꍇ͍ 2 ]
					else if(node->m_pRight->m_Balance == node_type::LEFT)
					{
						value_ptr p = static_cast<value_ptr>(node->m_pRight->m_pLeft);
						this->m_root = this->rotate_left2(p);
						if(p->m_Balance == node_type::LEFT)
						{
							p->m_pLeft->m_Balance = node_type::EVEN;
							p->m_pRight->m_Balance = node_type::RIGHT;
						}
						else if(p->m_Balance == node_type::RIGHT)
						{
							p->m_pLeft->m_Balance = node_type::LEFT;
							p->m_pRight->m_Balance = node_type::EVEN;
						}
						else
						{
							p->m_pLeft->m_Balance = node_type::EVEN;
							p->m_pRight->m_Balance = node_type::EVEN;
						}
						p->m_Balance = node_type::EVEN;
					}
					break;
				}
			}
			// em[hoXĂ
			else
			{
				// m[hɒǉꂽꍇ
				if(node->m_pLeft == add)
				{
					// ǉꂽق̎qm[h̃oXĂꍇ
					if(node->m_pLeft->m_Balance == node_type::EVEN)
					{
						if( this->is_null_node(node->m_pRight) )	node->m_Balance = node_type::LEFT;
						else						break;
					}
					// ǉꂽق̎qm[h̃oXǂ炩ɌXĂꍇ
					else
					{
						node->m_Balance = node_type::LEFT;
					}
				}
				// m[hEɒǉꂽꍇ
				else
				{
					// ǉꂽق̎qm[h̃oXĂꍇ
					if(node->m_pRight->m_Balance == node_type::EVEN)
					{
						if( this->is_null_node(node->m_pLeft) )	node->m_Balance = node_type::RIGHT;
						else						break;
					}
					// ǉꂽق̎qm[h̃oXǂ炩ɌXĂꍇ
					else
					{
						node->m_Balance = node_type::RIGHT;
					}
				}
			}
			add = node;
		} while((node = static_cast<value_ptr>(node->m_pParent)) != nullptr);

		return this->m_root;
	}

	/**
	 * @brief	c[]ăoX𐮂(m[h̍폜)
	 * @param [in]	node	= 폜sm[h̐e
	 * @param [in]	key		= 폜sm[h̃L[
	 * @param [in]	swapkey	= 폜ɌL[
	 * @return	]̃[gm[h
	*/
	virtual	value_ptr		rotate_tree_sub(value_ptr node, value_ptr key, node_ptr swapkey)
	{
		if(this->m_root == nullptr)	return nullptr;
		value_ptr sub = key;
		// node  nullptr ̏ꍇ̓c[[ĝ݂Ȃ̂ŉsȂ
		if(node == nullptr)	return this->m_root;
		bool is_left = (swapkey != nullptr || node->is_has_child() ) ?
			( (node->m_pLeft == swapkey) ? true : false )
			: ( (node->m_Balance == node_type::LEFT) ? true : false);

		// m[he root ܂ŎJ
		do
		{
			// em[hɌXĂ
			if(node->m_Balance == node_type::LEFT)
			{
				// ̃m[h폜ꂽꍇ
				if( is_left )
				{
					node->m_Balance = node_type::EVEN;
				}
				// Ẽm[h폜ꂽꍇ
				else
				{
					// ̃m[hEɌXĂꍇ͉E 2 ]
					if(node->m_pLeft->m_Balance == node_type::RIGHT)
					{
						value_ptr p = static_cast<value_ptr>(node->m_pLeft->m_pRight);
						this->m_root = this->rotate_right2(p);
						if( p->m_Balance == node_type::LEFT )
						{
							p->m_Balance = node_type::EVEN;
							p->m_pLeft->m_Balance = node_type::EVEN;
							p->m_pRight->m_Balance = node_type::RIGHT;
						}
						else if( p->m_Balance == node_type::RIGHT )
						{
							p->m_pRight->m_Balance = node_type::EVEN;
							p->m_pLeft->m_Balance = node_type::LEFT;
							p->m_Balance = node_type::EVEN;
						}
						else
						{
							p->m_Balance = node_type::EVEN;
							p->m_pRight->m_Balance = node_type::EVEN;
							p->m_pLeft->m_Balance = node_type::EVEN;
						}
						if(p->m_Balance != node_type::EVEN)
							break;
						node = p;
					}
					// ̃m[hEɌXĂȂꍇ͉E 1 ]
					else
					{
						value_ptr p = static_cast<value_ptr>(node->m_pLeft);
						this->m_root = this->rotate_right1(p);
						if(p->m_Balance == node_type::EVEN)
						{
							p->m_Balance = node_type::RIGHT;
							if( this->is_null_node(p->m_pRight->m_pLeft) )
								p->m_pRight->m_Balance = node_type::EVEN;
						}
						else
						{
							p->m_Balance = node_type::EVEN;
							p->m_pRight->m_Balance = node_type::EVEN;
						}
						if(node->m_pParent->m_Balance != node_type::EVEN)
							break;
						node = p;
					}
				}
			}
			// em[hEɌXĂ
			else if(node->m_Balance == node_type::RIGHT)
			{
				// ̃m[h폜ꂽꍇ
				if( is_left )
				{
					// Ẽm[hɌXĂꍇ͍ 2 ]
					if(node->m_pRight->m_Balance == node_type::LEFT)
					{
						value_ptr p = static_cast<value_ptr>(node->m_pRight->m_pLeft);
						this->m_root = this->rotate_left2(p);
						if( p->m_Balance == node_type::LEFT )
						{
							p->m_Balance = node_type::EVEN;
							p->m_pLeft->m_Balance = node_type::EVEN;
							p->m_pRight->m_Balance = node_type::RIGHT;
						}
						else if( p->m_Balance == node_type::RIGHT )
						{
							p->m_pRight->m_Balance = node_type::EVEN;
							p->m_pLeft->m_Balance = node_type::LEFT;
							p->m_Balance = node_type::EVEN;
						}
						else
						{
							p->m_Balance = node_type::EVEN;
							p->m_pRight->m_Balance = node_type::EVEN;
							p->m_pLeft->m_Balance = node_type::EVEN;
						}
						if(p->m_Balance != node_type::EVEN)
							break;
						node = p;
					}
					// Ẽm[hɌXĂȂꍇ͍ 1 ]
					else
					{
						value_ptr p = static_cast<value_ptr>(node->m_pRight);
						this->m_root = this->rotate_left1(p);
						if(p->m_Balance == node_type::EVEN)
						{
							p->m_Balance = node_type::LEFT;
							if( this->is_null_node(p->m_pLeft->m_pRight) )
								p->m_pLeft->m_Balance = node_type::EVEN;
						}
						else
						{
							p->m_Balance = node_type::EVEN;
							p->m_pLeft->m_Balance = node_type::EVEN;
						}
						if(node->m_pParent->m_Balance != node_type::EVEN)
							break;
						node = p;
					}
				}
				// Ẽm[h폜ꂽꍇ
				else
				{
					node->m_Balance = node_type::EVEN;
				}
			}
			// em[hoXĂ
			else
			{
				// ̃m[h폜ꂽꍇ
				if( is_left )
				{
					// 폜ꂽق̎qm[h̃oXĂꍇ
					IRIS_ASSERT(node->m_pLeft == nullptr || node->m_pLeft->m_Balance == node_type::EVEN);
					node->m_Balance = node_type::RIGHT;
				}
				// Ẽm[h폜ꂽꍇ
				else
				{
					// 폜ꂽق̎qm[h̃oXĂꍇ
					IRIS_ASSERT(node->m_pRight == nullptr || node->m_pRight->m_Balance == node_type::EVEN);
					node->m_Balance = node_type::LEFT;
				}
				break;
			}
			sub = node;
			node = static_cast<value_ptr>(node->m_pParent);
			if( node == nullptr ) break;
			is_left = node->m_pLeft == sub ? true : false;
		} while(1);

		return this->m_root;
	}

	/**
	 * @brief	m[h̃oXăZbg
	*/
	void	_balance(node_ptr ptr)
	{
		IRIS_ASSERT( ptr != nullptr );
		int lh = height(ptr->m_pLeft);
		int rh = height(ptr->m_pRight);
		if( lh > rh ) ptr->m_Balance = node_type::LEFT;
		else if( lh < rh ) ptr->m_Balance = node_type::RIGHT;
		else ptr->m_Balance = node_type::EVEN;
	}

#ifndef _IRIS_DEBUG
public:
	void print(void)	const {}
#else
public:
	/**
	 * @brief c[Wo͂ɕ\B
	*/
	void print(void)	const
	{
		value_ptr	next = this->m_root;
		s32			indent = 0;

		if(next == nullptr) { return; }
		while(1)
		{
			int i;
			for(i = 0; i < indent; ++i)
			{
				printf(" ");
			}
			printf("key:0x%08x ", (u32)(u32w64)next);
			printf("l:");
			if(next->m_pLeft != nullptr)
			{
				IRIS_ASSERT( next->m_pLeft->m_pParent == next );
				printf("0x%08x ", (u32)(u32w64)next->m_pLeft);
			}
			else						printf("- ");

			printf("r:");
			if(next->m_pRight != nullptr)
			{
				IRIS_ASSERT( next->m_pRight->m_pParent == next );
				printf("0x%08x ", (u32)(u32w64)next->m_pRight);
			}
			else						printf("- ");
			printf("b:%c x:%x\n", next->m_Balance, (u32)(u32w64)next);

			if(next->m_pLeft != nullptr)
			{
				++indent;
				next = static_cast<value_ptr>(next->m_pLeft);
			}
			else if(next->m_pRight != nullptr)
			{
				++indent;
				next = static_cast<value_ptr>(next->m_pRight);
			}
			else
			{
				value_ptr parent;
				while(1)
				{
					parent = static_cast<value_ptr>(next->m_pParent);
					if(parent == nullptr) return;
					--indent;
					if(parent->m_pRight == next)
					{
						next = parent;
					}
					else
					{
						next = parent;
						if(next->m_pRight != nullptr)
						{
							next = static_cast<value_ptr>(next->m_pRight);
							++indent;
							break;
						}
					}
				}
			}
		}
	}
#endif

#ifdef _IRIS_DEBUGTEST_ENABLE
	/// m[h̐
	void	check_node(value_ptr node)	const
	{
		if( node == nullptr ) return;
		if( node->m_pParent != nullptr )
		{
			IRIS_ASSERT(node->m_pParent->m_pLeft == node || node->m_pParent->m_pRight == node);
			if( node->m_pParent->m_Balance == node_type::LEFT )
			{
				if( node->m_pParent->m_pLeft == node )
				{
					if(node->m_pLeft == nullptr && node->m_pRight == nullptr) { IRIS_ASSERT(node->m_pParent->m_pRight == nullptr); }
					else												{ IRIS_ASSERT(node->m_pParent->m_pRight != nullptr); }
				}
				else
				{
					IRIS_ASSERT(node->m_pParent->m_pLeft != nullptr);
				}
			}
			else if( node->m_pParent->m_Balance == node_type::RIGHT )
			{
				if( node->m_pParent->m_pRight == node )
				{
					if(node->m_pLeft == nullptr && node->m_pRight == nullptr)	{ IRIS_ASSERT(node->m_pParent->m_pLeft == nullptr); }
					else												{ IRIS_ASSERT(node->m_pParent->m_pLeft != nullptr); }
				}
				else
				{
					IRIS_ASSERT(node->m_pParent->m_pRight != nullptr);
				}
			}
			else
			{
				if( node->m_pParent->m_pLeft == node )	{ IRIS_ASSERT(node->m_pParent->m_pRight != nullptr); }
				else									{ IRIS_ASSERT(node->m_pParent->m_pLeft  != nullptr); }
			}
		}

		if( node->m_pLeft  != nullptr )	IRIS_ASSERT( node->m_pLeft->m_pParent  == node );
		if( node->m_pRight != nullptr )	IRIS_ASSERT( node->m_pRight->m_pParent == node );
		if( node->m_pLeft == nullptr && node->m_pRight != nullptr )
			IRIS_ASSERT( node->m_Balance == node_type::RIGHT );
		if( node->m_pLeft != nullptr && node->m_pRight == nullptr )
			IRIS_ASSERT( node->m_Balance == node_type::LEFT );
		if( node->m_pLeft == nullptr && node->m_pRight == nullptr )
			IRIS_ASSERT( node->m_Balance == node_type::EVEN );
		if( node->m_pLeft != nullptr && node->m_pRight != nullptr )
		{
			int lh = height(node->m_pLeft);
			int rh = height(node->m_pRight);
			if( lh < rh )
			{
				IRIS_ASSERT( rh == lh+1 );
				IRIS_ASSERT( node->m_Balance == node_type::RIGHT );
			}
			else if( lh > rh )
			{
				IRIS_ASSERT( lh == rh+1 );
				IRIS_ASSERT( node->m_Balance == node_type::LEFT );
			}
			else
				IRIS_ASSERT( node->m_Balance == node_type::EVEN );
		}

		{
			node_ptr next = node->m_pLeft;
			s32 lh=0, rh=0;
			while( next != nullptr )
			{
				++lh;
				if( next->m_pLeft == nullptr )
					next = next->m_pRight;
				else if( next->m_pRight == nullptr )
					next = next->m_pLeft;
				else if( next->m_Balance == node_type::LEFT )
					next = next->m_pLeft;
				else
					next = next->m_pRight;
			}

			next = node->m_pRight;
			while( next != nullptr )
			{
				++rh;
				if( next->m_pLeft == nullptr )
					next = next->m_pRight;
				else if( next->m_pRight == nullptr )
					next = next->m_pLeft;
				else if( next->m_Balance == node_type::LEFT )
					next = next->m_pLeft;
				else
					next = next->m_pRight;
			}

			if( lh == rh )	IRIS_ASSERT(node->m_Balance == node_type::EVEN);
			if( lh > rh )	IRIS_ASSERT(node->m_Balance == node_type::LEFT);
			if( lh < rh )	IRIS_ASSERT(node->m_Balance == node_type::RIGHT);
		}
	}
#endif
};


}	// end of namespace fnd
}	// end of namespace iris

#endif
