//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndAIFF.cpp
 * @brief		AIFFtH[}bgt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndAIFF_CPP_

//======================================================================
// include
#include "FndAIFF.h"

namespace iris {
namespace fnd
{

//======================================================================
// class

}	// end of namespace fnd
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../io/FndFile.h"
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"
#include <string.h>

//======================================================================
// test
IRIS_UNITTEST(CFndAIFFUnitTest, Func)
{
	CAIFFBuffer<fnd::CFile> aiff;
	char path[MAX_PATH] = "sample.at3";

#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
	std::cout << "Jt@C͂ĂB" << std::endl;
	std::cin >> path;
#endif

	if( !aiff.Open(path) )
	{
		std::cout << "t@CI[vɎs܂B" << std::endl;
		goto end;
	}

	{
		std::cout << "AIFF FMT = 0x" << std::hex << aiff.GetFormType() << std::dec << std::endl;
		std::cout << "------------------------------" << std::endl;
		char id_str[5];
		id_str[4] = '\0';
		LPAIFF_CHUNK_HEADER head = aiff.GetNextChunk(nullptr);
		while(head != nullptr)
		{
			memcpy(id_str, &head->uID, sizeof(head->uID));
			switch( head->uID )
			{
			case AIFF_ID_COMM_CHUNK:
				{
					LPAIFF_COMM_CHUNK chunk = (LPAIFF_COMM_CHUNK)head;
					std::cout << "ID             : " << id_str << std::endl;
					std::cout << "SIZE           : " << chunk->Size << std::endl;
					std::cout << "Channels       : " << chunk->Channels << std::endl;
					std::cout << "SampleFrames   : " << chunk->SampleFrames << std::endl;
					std::cout << "wBitsPerSample : " << chunk->wBitsPerSample << std::endl;
					std::cout << "SamplingRate : " << (double)chunk->SampleRate << std::endl;
				}
				break;
			case AIFF_ID_SSND_CHUNK:
				{
					LPAIFF_SSND_CHUNK chunk = (LPAIFF_SSND_CHUNK)head;
					std::cout << "ID        : " << id_str << std::endl;
					std::cout << "SIZE      : " << chunk->Size << std::endl;
					std::cout << "Offset    : " << chunk->Offset << std::endl;
					std::cout << "BlockSize : " << chunk->BlockSize << std::endl;
				}
				break;
			case AIFF_ID_NAME_CHUNK:
			case AIFF_ID_AUTH_CHUNK:
			case AIFF_ID_CRIGHT_CHUNK:
			case AIFF_ID_ANNO_CHUNK:
				{
					LPAIFF_TEXT_CHUNK chunk = (LPAIFF_TEXT_CHUNK)head;
					std::cout << "ID        : " << id_str << std::endl;
					std::cout << "SIZE      : " << chunk->Size << std::endl;
					std::cout << "TEXT      : " << chunk->Text << std::endl;
				}
				break;
			case AIFF_ID_COMT_CHUNK:
				{
					LPAIFF_COMT_CHUNK chunk = (LPAIFF_COMT_CHUNK)head;
					std::cout << "ID      : " << id_str << std::endl;
					std::cout << "SIZE    : " << chunk->Size << std::endl;
					std::cout << "NUM     : " << chunk->nComment << std::endl;

					for( int i=0; i < chunk->nComment; ++i )
					{
						std::cout << "TIME   : " << chunk->Comments[i].timeStamp << std::endl;
						std::cout << "MARK   : " << chunk->Comments[i].Marker << std::endl;
						std::cout << "LENGTH : " << chunk->Comments[i].Count << std::endl;
						std::cout << "TEXT   : " << chunk->Comments[i].Text << std::endl;
					}
				}
				break;
			default:
				{
					LPAIFF_CHUNK chunk = (LPAIFF_CHUNK)head;
					std::cout << "ID   : " << id_str << std::endl;
					std::cout << "SIZE : " << chunk->Size << std::endl;
				}
				break;
			}
			std::cout << "------------------------------" << std::endl;
			head = (LPAIFF_CHUNK_HEADER)aiff.GetNextChunk(head);
		}
	}
end:
	return;
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
