//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndAIFF.h
 * @brief		AIFFtH[}bgt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndAIFF_H_
#define INCG_IRIS_FndAIFF_H_

//======================================================================
// include
#include "../io/FndIFile.h"
#include "../container/FndFileBuffer.h"
#include "FndIEEE80.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
template<typename FILE>class CAIFF;

//======================================================================
// typedef
typedef bes16		AIFFMarkID;

//======================================================================
// struct
/// AIFF `N
typedef struct tagAIFF_FILE_CHUNK
{
	u4cc	uID;		//!< t@Cʎq
	bes32	Size;		//!< t@CTCY
	u32		uForm;		//!< tH[^Cv
} AIFF_FILE_CHUNK, *LPAIFF_FILE_CHUNK;

/// AIFF Tu`N wb_
typedef struct tagAIFF_CHUNK_HEADER
{
	u4cc	uID;		//!< ʎq
	bes32	Size;		//!< TCY
} AIFF_CHUNK_HEADER, *LPAIFF_CHUNK_HEADER;

/// AIFF LIST `N
typedef struct tagAIFF_LIST_CHUNK
{
	u4cc	uID;		//!< ʎq
	bes32	Size;		//!< TCY
	u32		uType;		//!< Xg^Cv
} AIFF_LIST_CHUNK, *LPAIFF_LIST_CHUNK;

/// AIFF Tu`N
#include "../../misc/iris_pushpack1.h"
typedef struct tagAIFF_CHUNK
{
	u4cc	uID;		//!< ʎq
	bes32	Size;		//!< TCY
	u8		pData[1];	//!< f[^
} AIFF_CHUNK, *LPAIFF_CHUNK;
#include "../../misc/iris_poppack.h"

#include "../../misc/iris_pushpack2.h"
/// AIFF COMM `N
typedef struct tagAIFF_COMM_CHUNK
{
	u4cc			uID;			//!< ʎq
	bes32			Size;			//!< TCY
	beu16			Channels;		//!< `l
	beu32			SampleFrames;	//!< Tv
	bes16			wBitsPerSample;	//!< TvOTCY([1,32])
	CIEEEBinary80	SampleRate;		//!< TvO[g(80bit floating point)
} AIFF_COMM_CHUNK, *LPAIFF_COMM_CHUNK;
#include "../../misc/iris_poppack.h"

/// AIFF SSND `N
#include "../../misc/iris_pushpack1.h"
typedef struct tagAIFF_SSND_CHUNK
{
	u4cc	uID;		//!< ʎq
	bes32	Size;		//!< TCY
	beu32	Offset;		//!< ItZbg
	beu32	BlockSize;	//!< ubNTCY
	u8		pData[1];	//!< f[^
} AIFF_SSND_CHUNK, *LPAIFF_SSND_CHUNK;
#include "../../misc/iris_poppack.h"

/// AIFF Marker
typedef struct tagAIFF_MARKER
{
	AIFFMarkID	ID;			//!< ID
	u32			Position;	//!< ʒu
	char		pString[1];	//!< f[^
} AIFF_MARKER, *LPAIFF_MARKER;

#include "../../misc/iris_pushpack2.h"
/// AIFF Maker `N
typedef struct tagAIFF_MARK_CHUNK
{
	u4cc	uID;			//!< ʎq
	bes32	Size;			//!< TCY
	beu16	nMakers;		//!< AIFF_MAKER
	AIFF_MARKER Makers[1];	//!< AIFF_MAKER
} AIFF_MARK_CHUNK, *LPAIFF_MARK_CHUNK;
#include "../../misc/iris_poppack.h"

/// AIFF Loop 
typedef struct tagAIFF_LOOP
{
  bes16			PlayMode;	//!< [h
  AIFFMarkID	BeginLoop;	//!< [vJnʒu
  AIFFMarkID	EndLoop;	//!< [vIʒu
} AIFF_LOOP, *LPAIFF_LOOP;

#include "../../misc/iris_pushpack1.h"
/// AIFF Instrument `N
typedef struct tagAIFF_INST_CHUNK
{
	u4cc	uID;			//!< ʎq
	bes32	Size;			//!< TCY
	s8		BaseNote;		//!< 
	s8		Detune;			//!< f`F[
	s8		LowNote;		//!< 
	s8		HighNote;		//!< 
	s8		LowVelocity;	//!< 
	s8		HighVelocity;	//!< 
	s8		Gain;			//!< 
	AIFF_LOOP	SustainLoop;//!< 
	AIFF_LOOP	ReleaseLoop;//!< 
} AIFF_INST_CHUNK, *LPAIFF_INST_CHUNK;
#include "../../misc/iris_poppack.h"


/// AIFF MIDI `N
#include "../../misc/iris_pushpack1.h"
typedef struct tagAIFF_MIDI_CHUNK
{
	u4cc	uID;			//!< ʎq
	bes32	Size;			//!< TCY
	u8		pData[1];		//!< f[^
} AIFF_MIDI_CHUNK, *LPAIFF_MIDI_CHUNK;
#include "../../misc/iris_poppack.h"


/// AIFF Audio Recoding `N
typedef struct tagAIFF_AESD_CHUNK
{
	u4cc	uID;			//!< ʎq
	bes32	Size;			//!< TCY
	u8		AESChannelStatusData[24];		//!< f[^
} AIFF_AESD_CHUNK, *LPAIFF_AESD_CHUNK;


/// AIFF Application Specific `N
#include "../../misc/iris_pushpack1.h"
typedef struct tagAIFF_APPL_CHUNK
{
	u4cc	uID;			//!< ʎq
	bes32	Size;			//!< TCY
	u4cc	Signature;		//!< 
	u8		pData[1];		//!< f[^
} AIFF_APPL_CHUNK, *LPAIFF_APPL_CHUNK;
#include "../../misc/iris_poppack.h"


/// AIFF Rg
#include "../../misc/iris_pushpack1.h"
typedef struct tagAIFF_COMMENT
{
	beu32		timeStamp;		//!< ^CX^v
	AIFFMarkID	Marker;			//!< }[J[
	beu16		Count;			//!< RgTCY
	char		Text[1];		//!< Rg
} AIFF_COMMENT, *LPAIFF_COMMENT;
#include "../../misc/iris_poppack.h"

/// AIFF Comments `N
#include "../../misc/iris_pushpack1.h"
typedef struct tagAIFF_COMT_CHUNK
{
	u4cc			uID;			//!< ʎq
	bes32			Size;			//!< TCY
	beu16			nComment;		//!< Rg
	AIFF_COMMENT	Comments[1];	//!< Rg
} AIFF_COMT_CHUNK, *LPAIFF_COMT_CHUNK;
#include "../../misc/iris_poppack.h"


/// AIFF eLXg `N
#include "../../misc/iris_pushpack1.h"
typedef struct tagAIFF_TEXT_CHUNK
{
	u4cc	uID;			//!< ʎq
	bes32	Size;			//!< TCY
	char	Text[1];		//!< eLXg
} AIFF_TEXT_CHUNK, *LPAIFF_TEXT_CHUNK;
#include "../../misc/iris_poppack.h"

//======================================================================
// enum
// `Nʎq
typedef enum
{
	// big endian
	AIFF_ID_FILE_CHUNK	= IRIS_FOURCC_BE('F', 'O', 'R', 'M'),	//!< t@C
	AIFF_ID_FORMTYPE	= IRIS_FOURCC_BE('A', 'I', 'F', 'F'),	//!< tH[^Cv
	AIFC_ID_FORMTYPE	= IRIS_FOURCC_BE('A', 'I', 'F', 'C'),	//!< tH[^Cv
	AIFF_ID_COMM_CHUNK	= IRIS_FOURCC_BE('C', 'O', 'M', 'M'),	//!< ʃ`N
	AIFF_ID_SSND_CHUNK	= IRIS_FOURCC_BE('S', 'S', 'N', 'D'),	//!< SSND`N
	AIFF_ID_MARK_CHUNK	= IRIS_FOURCC_BE('M', 'A', 'R', 'K'),	//!< MAKER`N
	AIFF_ID_INST_CHUNK	= IRIS_FOURCC_BE('I', 'N', 'S', 'T'),	//!< INST`N
	AIFF_ID_MIDI_CHUNK	= IRIS_FOURCC_BE('M', 'I', 'D', 'I'),	//!< MIDI`N
	AIFF_ID_AESD_CHUNK	= IRIS_FOURCC_BE('A', 'E', 'S', 'D'),	//!< AESD`N
	AIFF_ID_APPL_CHUNK	= IRIS_FOURCC_BE('A', 'P', 'P', 'L'),	//!< APPL`N
	AIFF_ID_COMT_CHUNK	= IRIS_FOURCC_BE('C', 'O', 'M', 'T'),	//!< COMT`N

	// text chunk
	AIFF_ID_NAME_CHUNK	= IRIS_FOURCC_BE('N', 'A', 'M', 'E'),	//!< NAME`N
	AIFF_ID_AUTH_CHUNK	= IRIS_FOURCC_BE('A', 'U', 'T', 'H'),	//!< AUTHOR`N
	AIFF_ID_CRIGHT_CHUNK= IRIS_FOURCC_BE('(', 'c', ')', ' '),	//!< NAME`N
	AIFF_ID_ANNO_CHUNK	= IRIS_FOURCC_BE('A', 'N', 'N', 'O')	//!< Annotation`N
} AIFF_CHUNK_ID;

//======================================================================
// class
/// AIFFtH[}bgt@CNX
template<typename FILE>
class CAIFF : private INonCopyable<>
{
	typedef FILE	File;
	typedef typename fnd::CFileHandleClassType<FILE>::type	FileHandler;
protected:
	File	m_File;	//!< t@C
	u32		m_Form;	//!< tH[^Cv
public:
	//! RXgN^
	CAIFF(void) : m_Form(0)	{}
	//! fXgN^
	virtual ~CAIFF(void)	{ Close(); }
public:
	//! J
	template<typename CHARTYPE_>
	bool	Open(const CHARTYPE_* fname)
	{
		Close();

		// wb_mF
		FileHandler file;
		if( !file.Open(fname, FOPEN_READ) ) return false;
		AIFF_FILE_CHUNK header;
		if( file.Read(&header, sizeof(header)) == 0 ) return false;
		if( header.uID != AIFF_ID_FILE_CHUNK ) return false;
		file.Close();

		if( !m_File.Open(fname, FOPEN_READ) ) return false;
		m_Form = header.uForm;
		m_File.Seek(sizeof(header), FILE_SEEK_CUR);
		return true;
	}
	bool	OpenA(LPCSTR  fname)	{ return Open(fname); }
	bool	OpenW(LPCWSTR fname)	{ return Open(fname); }
	//! 
	void	Close(void)				{ m_File.Close(); }

public:
	//! LȏԂǂ
	bool	IsValid(void)		const	{ return m_File.IsOpen(); }
	//! t@CTCY̎擾
	u32		GetSize(void)		const	{ return m_File.GetSize(); }
	//! tH[^Cv̎擾
	u32		GetFormType(void)	const	{ return m_Form; }

public:
	//
	//! `Nɉ
	bool	Descend(u32 ChunkType)
	{
		if( !IsValid() ) return false;
		AIFF_CHUNK_HEADER chunk;
		while(1)
		{
			u32 seek = m_File.Tell();
			if( seek == m_File.GetSize() ) break;

			if( m_File.Read(&chunk, sizeof(chunk)) == 0 ) break;
			if( chunk.uID == ChunkType )
			{
				m_File.Seek(seek, FILE_SEEK_SET);
				return true;
			}
			else
			{
				m_File.Seek(chunk.Size, FILE_SEEK_CUR);
			}
		}
		return false;
	}
	//! 1i
	bool	Descend(void)
	{
		if( !IsValid() ) return false;
		AIFF_CHUNK_HEADER chunk;
		if( !m_File.Read(chunk, sizeof(chunk)) ) return false;
		m_File.Seek(chunk.Size, FILE_SEEK_CUR);
		return true;
	}

	//! `N
	bool	Ascend(void)
	{
		if( !IsValid() ) return false;
		m_File.Seek(sizeof(AIFF_FILE_CHUNK), FILE_SEEK_SET);
		return true;
	}

	//! `Nǂݎ
	size_t	Read(void* buf, size_t size)
	{
		if( !IsValid() ) return false;
		return m_File.Read(buf, size);
	}

	//! seek
	bool		Seek(long offset, int origin)	{ return m_File.Seek(offset, origin); }
	//! tell
	s32			Tell(void) const				{ return m_File.Tell(); }

};

/**
 * @brief	obt@WJς AIFF NX
*/
template<typename FILE>
class CAIFFBuffer : public CAIFF< CFileBuffer< typename CFileHandleClassType<FILE>::type > >
{
public:
	//! RXgN^
	CAIFFBuffer(void)	{}

public:
	// Tu`Ň
	LPAIFF_CHUNK		FindChunk(const LPAIFF_CHUNK_HEADER start)
	{
		if( !this->IsValid() ) return nullptr;
		LPAIFF_FILE_CHUNK head = pointer_cast<LPAIFF_FILE_CHUNK>(this->m_File.ptr());
		u32 size = this->m_File.GetSize();
		u8* end  = this->m_File.ptr() + size;
		if( size <= sizeof(AIFF_FILE_CHUNK) ) return nullptr;

		u8* next = start == nullptr ? pointer_cast<u8*>(head + 1) : pointer_cast<u8*>(start) + sizeof(AIFF_CHUNK) + start->Size;
		while(next < end)
		{
			LPAIFF_CHUNK chunk = pointer_cast<LPAIFF_CHUNK>(next);
			return chunk;
		}
		return nullptr;
	}
	// Tu`Ň
	LPAIFF_CHUNK		FindChunk(u32 ChunkType)
	{
		if( !this->IsValid() ) return nullptr;
		LPAIFF_FILE_CHUNK head = pointer_cast<LPAIFF_FILE_CHUNK>(this->m_File.ptr());
		u32 size = this->m_File.GetSize();
		u8* end  = this->m_File.ptr() + size;
		if( size <= sizeof(AIFF_FILE_CHUNK) ) return nullptr;

		u8* next = pointer_cast<u8*>(head + 1);
		while(next < end)
		{
			LPAIFF_CHUNK_HEADER chunk = pointer_cast<LPAIFF_CHUNK_HEADER>(next);
			if( chunk->uID == ChunkType )
			{
				return pointer_cast<LPAIFF_CHUNK>(chunk);
			}
			else
			{
				next = next + sizeof(AIFF_CHUNK_HEADER) + chunk->Size;
			}
		}
		return nullptr;
	}

	// ̃`N擾
	LPAIFF_CHUNK_HEADER	GetNextChunk(const LPAIFF_CHUNK_HEADER chunk)
	{
		if( !this->IsValid() ) return nullptr;
		LPAIFF_FILE_CHUNK head = pointer_cast<LPAIFF_FILE_CHUNK>(this->m_File.ptr());
		u32 size = this->m_File.GetSize();
		u8* end  = this->m_File.ptr() + size;
		if( size <= sizeof(AIFF_FILE_CHUNK) ) return nullptr;

		u8* next = pointer_cast<u8*>(head + 1);
		if( chunk != nullptr )
		{
			next = pointer_cast<u8*>(chunk) + sizeof(AIFF_CHUNK_HEADER) + chunk->Size;
		}
		if( next >= end ) return nullptr;
		return pointer_cast<LPAIFF_CHUNK_HEADER>(next);
	}
};


}	// end of namespace fnd
}	// end of namespace iris

#endif
