//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndCDDAToc.h
 * @brief		FndCDDAToc t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndCDDAToc_H_
#define INCG_IRIS_FndCDDAToc_H_

//======================================================================
// include
#include "../container/FndBuffer.h"
#include "../io/FndDeviceIO.h"
#include "../format/FndCDDA.h"
#include "../../iris_debug.h"

#if defined(_IRIS_SUPPORT_WDK)

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	Table of Contents ǂݎNX
*/
template<typename Allocator_ = CNewAllocator<u8> >
class CCDDAToc : public IIrisObject
{
	typedef int_least_type<MINIMUM_CDROM_READ_TOC_EX_SIZE*8>::UInt	size_type_raw;
	typedef endian_base<size_type_raw>::type	size_type;
	typedef typename CBuffer<u8, Allocator_>	_Mybuffer;

protected:
	CDDA_TOCINFO	m_TOC;		//!< Table of Contents
	CDDA_SESSION	m_Session;	//!< ZbV

public:
	/// RXgN^
	CCDDAToc(void) {}

public:
	/// J
	bool	Open(IDeviceIO* drive)
	{
		if( drive == nullptr ) return false;
		//if( !drive->IsValid() ) return false;
		//if( !drive->IsReady() ) return false;

		CDROM_READ_TOC_EX tocex = {0};
		tocex.Format = CDROM_READ_TOC_EX_FORMAT_FULL_TOC;
		tocex.Msf = 1;

		size_type size_info;
		DWORD dwRead = 0;
		if( !drive->IoControl(IOCTL_CDROM_READ_TOC_EX, &tocex, sizeof(tocex), &size_info, sizeof(size_info), &dwRead) )
			return false;

		size_type_raw size = size_info + sizeof(size_info);
		if( size & 1 ) ++size;

		_Mybuffer buffer;
		if( !buffer.alloc(size) ) return false;

		CDROM_TOC_FULL_TOC_DATA* pftd = pointer_cast<CDROM_TOC_FULL_TOC_DATA*>(buffer.ptr());
		if( !drive->IoControl(IOCTL_CDROM_READ_TOC_EX, &tocex, sizeof(tocex), pftd, size, &dwRead) )
			return false;

		u32 nBlocks = (dwRead - sizeof(CDROM_TOC_FULL_TOC_DATA))/sizeof(CDROM_TOC_FULL_TOC_DATA_BLOCK);
		int session = -1;
		u8 nTracks = 0;
		u8 nSession = 0;
		ZeroMemory(&m_TOC, sizeof(CDDA_TOCINFO));
		ZeroMemory(&m_Session, sizeof(CDDA_SESSION));
		m_TOC.FirstTrack = 1;	// JngbNԍ

		static const u8 LAST_SECTOR = 0xA2;
		for( u32 i=0; i < nBlocks; ++i )
		{
			PCDROM_TOC_FULL_TOC_DATA_BLOCK pDescriptors = pftd->Descriptors + i;
			if( pDescriptors->Point == LAST_SECTOR )
			{
				// ŏIZN^擾
				m_Session.EndFAD = MSF2FAD(pDescriptors->Msf);
				continue;
			}
			// PointtB[h199܂łŁÄ݂ʒuf[^̏ꍇ
			if( pDescriptors->Point >= 1 && pDescriptors->Point < (MAXIMUM_NUMBER_TRACKS-1)
				&& pDescriptors->Adr == ADR_ENCODES_CURRENT_POSITION )
			{
				UCHAR trackNo = pDescriptors->Point;
				UCHAR track = pDescriptors->Point;
				u32 StartFAD = MSF2FAD(pDescriptors->Msf);
				m_TOC.TrackInfo[track].Addr		= pDescriptors->Adr;
				m_TOC.TrackInfo[track].Control	= pDescriptors->Control;
				m_TOC.TrackInfo[track].StartFAD = StartFAD;
				m_TOC.TrackInfo[track].EndFAD	= m_Session.EndFAD;
				if( track > 0 && (StartFAD < m_Session.EndFAD)  )
				{
					// 1ȌIZN^ԍ
					m_TOC.TrackInfo[track-1].EndFAD = StartFAD;
				}
				m_TOC.TrackInfo[track].Session = pDescriptors->SessionNumber;

				// gbN + 1
				++nTracks;

				if( session != pDescriptors->SessionNumber )
				{
					// ZbVԍXV
					session = pDescriptors->SessionNumber;
					m_Session.StartTrack[session-1] = trackNo;	// gbNԍ
					m_Session.StartFAD[session-1]	= StartFAD;	// ZN^ԍ
					++nSession;
				}

			}
		}
		m_TOC.LastTrack = nTracks + 1u;
		m_Session.Count = nSession;
		return true;
	}

public:

	//! 擪gbNԍ擾
	u8	GetFirstTrackNo(void)	const	{ return m_TOC.FirstTrack; }

	//! ŏIgbNԍ擾
	u8	GetLastTrackNo(void)	const	{ return m_TOC.LastTrack; }

};

}	// end of namespace fnd
}	// end of namespace iris

#endif

#endif
