//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndIEEE80.h
 * @brief		IEEE754 80bit t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndIEEE80_H_
#define INCG_IRIS_FndIEEE80_H_

//======================================================================
// include
#include "FndIEEE.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	IEEE754 80bit NX
 * @note	bit : 1
 *			bit : 64
 *			wbit : 15
*/
class CIEEEBinary80 : public IIrisObject
{
protected:
	u8	m_buf[10];	//!< obt@(BIGENDIAN Ŋi[)
public:
	// RXgN^
	CIEEEBinary80(void) {}
public:
	// Rs[
	void	CopyBufferBE(const u8* buf)
	{
		for( int i=0; i < elementof(m_buf); ++i, ++buf ) m_buf[i] = *buf;
	}
	void	CopyBufferLE(const u8* buf)
	{
		for( int i=0; i < elementof(m_buf); ++i, ++buf ) m_buf[9-i] = *buf;
	}

public:
	operator float	(void)	const	{ return cast_to_float(); }
	operator double	(void)	const	{ return cast_to_double(); }

public:
	u8*			GetBuffer(void)			{ return m_buf; }
	const u8*	GetBuffer(void)	const	{ return m_buf; }

public:
	// 
	u32		sign(void) const		{ return (m_buf[0]>>7) & 1; }
	// w
	u32		exp(void) const			{ return (static_cast<u32>(m_buf[0]&0x7F) << 8) | (static_cast<u32>(m_buf[1]) << 0); }
	// 
	u64		frac(void) const
	{
		return (static_cast<u64>(m_buf[2]) << 56) | (static_cast<u64>(m_buf[3]) << 48) | (static_cast<u64>(m_buf[4]) << 40)
			|  (static_cast<u64>(m_buf[5]) << 32) | (static_cast<u64>(m_buf[6]) << 24) | (static_cast<u64>(m_buf[7]) << 16)
			|  (static_cast<u64>(m_buf[8]) <<  8) | (static_cast<u64>(m_buf[9]));
	}
private:
	float cast_to_float(void) const
	{
		CIEEEBinary32 ieee;
		u32 exp_ = exp();
		if( exp_ == (1<<15)-1 )
		{
			exp_ = (1<<8)-1;
		}
		else if( exp_ != 0 )
		{
			exp_ -= (1<<14)-1;
			exp_ += (1<<7)-1;
			if( exp_ & ~0xFF )
			{
				// INF
				ieee.value() = 0x7F800000;
				ieee.sign(sign());
				return ieee;
			}
		}
		ieee.sign(sign());
		ieee.exp(exp_);
		ieee.frac((frac()>>40)&0x7FFFFF);	// Öق1bit̂Ă
		return ieee;
	}
	double cast_to_double(void) const
	{
		CIEEEBinary64 ieee;
		u32 exp_ = exp();
		if( exp_ == (1<<15)-1 )
		{
			exp_ = (1<<11)-1;
		}
		else if( exp_ != 0 )
		{
			exp_ -= (1<<14)-1;
			exp_ += (1<<10)-1;
			if( exp_ & ~0x7FF )
			{
				// INF
				ieee.value() = 0x7FF0000000000000;
				ieee.sign(sign());
				return ieee;
			}
		}
		ieee.sign(sign());
		ieee.exp(exp_);
		ieee.frac((frac()>>11)&0xFFFFFFFFFFFFF);	// Öق1bit̂Ă
		return ieee;
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
