//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndRIFF.cpp
 * @brief		RIFFtH[}bgt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndRIFF_CPP_

//======================================================================
// include
#include "FndRIFF.h"

namespace iris {
namespace fnd
{

//======================================================================
// class

}	// end of namespace fnd
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../io/FndFile.h"
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"
#include <string.h>

//======================================================================
// test
IRIS_UNITTEST(CFndRIFFUnitTest, Func)
{
	CRIFFBuffer<fnd::CFile> riff;
	char path[MAX_PATH] = "../../../data/snd/sample.wav";

#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
	std::cout << "Jt@C͂ĂB" << std::endl;
	std::cin >> path;
#endif

	if( !riff.Open(path) )
	{
		std::cout << "t@CI[vɎs܂B" << std::endl;
		goto end;
	}

	{
		std::cout << "RIFF FMT = 0x" << std::hex << riff.GetFormType() << std::dec << std::endl;
		std::cout << "------------------------------" << std::endl;
		char id_str[5];
		id_str[4] = '\0';
		LPRIFF_CHUNK_HEADER head = riff.GetNextChunk(nullptr);
		while(head != nullptr)
		{
			memcpy(id_str, &head->uID, sizeof(head->uID));
			switch( head->uID )
			{
			case RIFF_ID_LIST_CHUNK:
				{
					LPRIFF_LIST_CHUNK chunk = (LPRIFF_LIST_CHUNK)head;
					std::cout << "ID   : " << id_str << std::endl;
					std::cout << "SIZE : " << chunk->Size << std::endl;
					memcpy(id_str, &chunk->uType, sizeof(chunk->uType));
					std::cout << "TYPE : " << id_str << std::endl;
				}
				break;
			case RIFF_ID_FMT_CHUNK:
				{
					if(head->Size == (sizeof(RIFF_FMT_CHUNK) - sizeof(RIFF_CHUNK_HEADER)) )
					{
						LPRIFF_FMT_CHUNK chunk = (LPRIFF_FMT_CHUNK)head;
						std::cout << "ID         : " << id_str << std::endl;
						std::cout << "SIZE       : " << chunk->Size << std::endl;
						std::cout << "Fmt        : 0x" << std::hex << chunk->Fmt << std::dec << std::endl;
						std::cout << "Channels   : " << chunk->Channels << std::endl;
						std::cout << "Samples    : " << chunk->SamplePerSec << std::endl;
						std::cout << "BytePerSec : " << chunk->BytePerSec << std::endl;
						std::cout << "BlockAlign : " << chunk->BlockAlign << std::endl;
						std::cout << "BitsWidth  : " << chunk->BitsWidth << std::endl;
					}
					else
					{
						LPRIFF_FMT_EX_CHUNK chunk = (LPRIFF_FMT_EX_CHUNK)head;
						std::cout << "ID         : " << id_str << std::endl;
						std::cout << "SIZE       : " << chunk->Size << std::endl;
						std::cout << "Fmt        : 0x" << std::hex << chunk->Fmt << std::dec << std::endl;
						std::cout << "Channels   : " << chunk->Channels << std::endl;
						std::cout << "Samples    : " << chunk->SamplePerSec << std::endl;
						std::cout << "BytePerSec : " << chunk->BytePerSec << std::endl;
						std::cout << "BlockAlign : " << chunk->BlockAlign << std::endl;
						std::cout << "BitsWidth  : " << chunk->BitsWidth << std::endl;
						std::cout << "ExtSize    : " << chunk->ExtSize << std::endl;
					}
				}
				break;
			case RIFF_ID_FACT_CHUNK:
				{
					LPRIFF_CHUNK chunk = (LPRIFF_CHUNK)head;
					std::cout << "ID          : " << id_str << std::endl;
					std::cout << "SIZE        : " << chunk->Size << std::endl;
					switch( chunk->Size )
					{
					case 8:
						{
							IrisU32* samples = (IrisU32*)chunk->pData;
							std::cout << "(ALL - ZERO) SAMPLES: " << samples[0] << std::endl;
							std::cout << "ZERO SAMPLES        : " << samples[1] << std::endl;
						}
						break;
					case 4:
						{
							IrisU32 samples = *(IrisU32*)chunk->pData;
							std::cout << "ALL SAMPLES : " << samples << std::endl;
						}
						break;
					case 2:
						{
							u16 samples = *(u16*)chunk->pData;
							std::cout << "ALL SAMPLES : " << samples << std::endl;
						}
						break;
					case 1:
						{
							u8 samples = *(u8*)chunk->pData;
							std::cout << "ALL SAMPLES : " << samples << std::endl;
						}
						break;
					}
				}
				break;
			case RIFF_ID_SMPL_CHUNK:
				{
					LPRIFF_SMPL_CHUNK chunk = (LPRIFF_SMPL_CHUNK)head;
					std::cout << "ID                : " << id_str << std::endl;
					std::cout << "SIZE              : " << chunk->Size << std::endl;
					std::cout << "Manufacturer      : " << chunk->Manufacturer << std::endl;
					std::cout << "Product           : " << chunk->Product << std::endl;
					std::cout << "SamplePeriod      : " << chunk->SamplePeriod << std::endl;
					std::cout << "MIDIUnityNote     : " << chunk->MIDIUnityNote << std::endl;
					std::cout << "MIDIPitchFraction : " << chunk->MIDIPitchFraction << std::endl;
					std::cout << "SMPTEFormat       : " << chunk->SMPTEFormat << std::endl;
					std::cout << "SMPTEOffset       : " << chunk->SMPTEOffset << std::endl;
					std::cout << "SampleLoops       : " << chunk->SampleLoops << std::endl;
					std::cout << "SamplerData       : " << chunk->SamplerData << std::endl;
					for( IrisS32 i=0; i < chunk->SampleLoops; ++i )
					{
						std::cout << "Identifier    : " << chunk->Loops[0].Identifier << std::endl;
						std::cout << "Type          : " << chunk->Loops[0].Type << std::endl;
						std::cout << "Start         : " << chunk->Loops[0].Start << std::endl;
						std::cout << "End           : " << chunk->Loops[0].End << std::endl;
						std::cout << "Fraction      : " << chunk->Loops[0].Fraction << std::endl;
						std::cout << "PlayCount     : " << chunk->Loops[0].PlayCount << std::endl;
					}
				}
				break;
			default:
				{
					LPRIFF_CHUNK chunk = (LPRIFF_CHUNK)head;
					std::cout << "ID   : " << id_str << std::endl;
					std::cout << "SIZE : " << chunk->Size << std::endl;
				}
				break;
			}
			std::cout << "------------------------------" << std::endl;
			head = (LPRIFF_CHUNK_HEADER)riff.GetNextChunk(head);
		}
	}
end:
	return;
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
